
<?php $__env->startSection('content'); ?>
    <div class="page-content">
        <div class="container-fluid">
            <div class="box-typical box-typical-padding">
                <form action="<?php echo e(route('report.sales')); ?>" method="POST">
                    <div class="row">
                        <div class="col-sm-6">
                            <?php echo csrf_field(); ?>
                            <div class="row">
                                <div class="form-group col-md-4">
                                    <label><?php echo e(__('messages.start_date')); ?></label>
                                    <input type="text" class="form-control datepicker" name="sdate"
                                        value="<?php echo e($sdate); ?>">
                                </div>
                                <div class="form-group col-md-4 ">
                                    <label><?php echo e(__('messages.end_date')); ?></label>
                                    <input type="text" class="form-control datepicker" name="edate"
                                        value="<?php echo e($edate); ?>">
                                </div>
                                <div class="col-md-4">
                                    <button class="btn btn-purple mt-20" type="submit"> <?php echo e(__('messages.submit')); ?></button>
                                </div>
                            </div>
                        </div>
                        <div class="col-sm-6">
                            <div class="row">
                                <?php $__currentLoopData = $branches; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $br): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <?php if($branch_ids != ''): ?>
                                        <?php if(in_array($br->branch_id, $branch_ids)): ?>
                                            <div class="col-md-3">
                                                <input type="checkbox" name="brnchk[]" class=""
                                                    value="<?php echo e($br->branch_id); ?>" checked> <?php echo e($br->branch_name); ?>

                                            </div>
                                        <?php else: ?>
                                            <div class="col-md-3">
                                                <input type="checkbox" name="brnchk[]" class=""
                                                    value="<?php echo e($br->branch_id); ?>"> <?php echo e($br->branch_name); ?>

                                            </div>
                                        <?php endif; ?>
                                    <?php else: ?>
                                        <div class="col-md-3">
                                            <input type="checkbox" name="brnchk[]" class=""
                                                value="<?php echo e($br->branch_id); ?>"> <?php echo e($br->branch_name); ?>

                                        </div>
                                    <?php endif; ?>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </div>
                        </div>
                    </div>
                </form>
            </div>
            <div class="box-typical box-typical-padding">
                <div class="row">
                    <div class="col-md-12">
                        <table class="table" id="salesTable">
                            <thead>
                                <tr>
                                    <th> # </th>
                                    <th> <?php echo e(__('messages.date/time')); ?> </th>
                                    <th> <?php echo e(__('messages.branch')); ?> </th>
                                    <th> <?php echo e(__('messages.invoice')); ?> </th>
                                    <th> <?php echo e(__('messages.payment_type')); ?> </th>
                                    <th> <?php echo e(__('messages.sub_total')); ?> </th>
                                    <th> <?php echo e(__('messages.discount')); ?> </th>
                                    <th> <?php echo e(__('messages.grand_total')); ?> </th>
                                    <th> <?php echo e(__('messages.purchases')); ?> </th>
                                    <th> <?php echo e(__('messages.difference')); ?> </th>
                                    <th> <?php echo e(__('messages.invoice')); ?> </th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php
                                    $sno = 0;
                                    $total_st = 0;
                                    $total_ds = 0;
                                    $total_gt = 0;
                                    $total_ph = 0;
                                ?>
                                <?php $__currentLoopData = $sales; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $sls): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <?php$sno++;?>
                                    <tr>
                                        <td><?php echo e($loop->iteration); ?></td>
                                        <td><?php echo e($sls->dated); ?></td>
                                        <td><?php echo e($sls->branch->branch_name); ?></td>
                                        <td>
                                            <a href="#" id="<?php echo e($sls->invoice); ?>" data-toggle="modal"
                                                data-target="#sinvoice-details"><?php echo e($sls->invoice); ?></a>
                                        </td>
                                        <td><?php echo e($sls->payment_type); ?></td>
                                        <td class="total_st"><?php echo e($sls->sub_total); ?></td>
                                        <td class="total_ds"><?php echo e($sls->discount); ?></td>
                                        <td class="total_gt"><?php echo e($sls->grand_total); ?></td>
                                        <td class="total_ph"><?php echo e($sls->purchases); ?></td>
                                        <td class="total_diff"><?php echo e(formatAmount($sls->grand_total - $sls->purchases)); ?>

                                        </td>
                                        <td><a href="<?php echo e(route('sales.invoice', ['id' => $sls->invoice])); ?>"
                                                target="_blank"><i class="fa fa-print"></i></a></td>
                                    </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </tbody>
                            <tfoot>
                                <tr>
                                    <th>&nbsp;</th>
                                    <th>&nbsp;</th>
                                    <th>&nbsp;</th>
                                    <th>&nbsp;</th>
                                    <th>&nbsp;</th>
                                    <th class="text-purple" id="total_st"></th>
                                    <th class="text-warning" id="total_ds"></th>
                                    <th class="text-success" id="total_gt"></th>
                                    <th class="text-danger" id="total_ph"></th>
                                    <th class="text-info" id="total_diff"></th>
                                    <th>&nbsp;</th>
                                </tr>
                            </tfoot>
                        </table>
                    </div>
                </div>
            </div><!--.container-fluid-->
            <div id="sinvoice-details" class="modal fade" role="dialog">
                <div class="modal-dialog modal-lg">
                    <!-- Modal content-->
                    <div class="modal-content">
                        <div class="modal-header">
                            <button type="button" class="modal-close" data-dismiss="modal">
                                <i class="font-icon-close-2"></i>
                            </button>
                            <h4 class="modal-title"><?php echo e(__('messages.invoice')); ?> : <span id="invoice_number"></span></h4>
                        </div>
                        <div class="modal-body" id="sinvoice-mbody">

                        </div>
                        <div class="modal-footer">
                            <button type="button" class="btn btn-default" data-dismiss="modal"><?php echo e(__('messages.close')); ?></button>
                        </div>
                    </div>
                </div>
            </div>
        </div><!--.page-content-->
    <?php $__env->stopSection(); ?>
    <?php $__env->startSection('customjs'); ?>
        <script src="<?php echo e(asset('custom_js/reports.js')); ?>"></script>
    <?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.template.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/craftada/iftikhar.appssoul.com/resources/views/admin/report_sales.blade.php ENDPATH**/ ?>