@extends('admin.template.master')
@section('content')
    <div class="page-content">
        <div class="container-fluid">
            <div class="box-typical box-typical-padding">
                <form action="{{ route('report.returns') }}" method="POST">
                    <div class="row">
                        <div class="col-sm-6">
                            @csrf
                            <div class="row">
                                <div class="form-group col-md-4">
                                    <label>{{__('messages.start_date')}}</label>
                                    <input type="text" class="form-control datepicker" name="sdate"
                                        value="{{ $sdate }}">
                                </div>
                                <div class="form-group col-md-4 ">
                                    <label>{{__('messages.end_date')}}</label>
                                    <input type="text" class="form-control datepicker" name="edate"
                                        value="{{ $edate }}">
                                </div>
                                <div class="col-md-4">
                                    <button class="btn btn-purple mt-20" type="submit"> {{__('messages.submit')}}</button>
                                </div>
                            </div>
                        </div>
                    </div>
                </form>
            </div>
            <div class="box-typical box-typical-padding">
                <div class="row">
                    <div class="col-md-12">
                        <table class="table MyTable">
                            <thead>
                                <tr>
                                    <th> # </th>
                                    <th> {{__('messages.date/time')}} </th>
                                    <th> {{__('messages.invoice')}} </th>
                                    <th> {{__('messages.name')}}-{{__('messages.barcode')}} </th>
                                    <th> {{__('messages.price')}} </th>
                                    <th> {{__('messages.quantity')}} </th>
                                    <th> {{__('messages.total')}} </th>
                                </tr>
                            </thead>
                            <tbody>

                                @php
                                    $total = 0;
                                @endphp
                                @foreach ($returns as $rtn)
                                    <tr>
                                        <td>{{ $loop->iteration }}</td>
                                        <td>{{ $rtn->dated }}</td>
                                        <td>{{ $rtn->invoice }}</td>
                                        <td>{{ $rtn->item_name }}</td>
                                        <td>{{ $rtn->item_price }}</td>
                                        <td>{{ $rtn->item_qty }}</td>
                                        <td>{{ $rtn->item_total }}</td>
                                    </tr>
                                    @php
                                        $total += $rtn->item_total;
                                    @endphp
                                @endforeach
                            </tbody>
                            <tfoot>
                                <tr>
                                    <th>&nbsp;</th>
                                    <th>&nbsp;</th>
                                    <th>&nbsp;</th>
                                    <th>&nbsp;</th>
                                    <th>&nbsp;</th>
                                    <th>&nbsp;</th>
                                    <th>{{ formatAmount($total) }}</th>
                                </tr>
                            </tfoot>
                        </table>
                    </div>
                </div>
            </div><!--.container-fluid-->

        </div><!--.page-content-->
    @endsection
    @section('customjs')
        <script src="{{ asset('custom_js/reports.js') }}"></script>
    @endsection
