@extends('admin.template.master')
@section('content')
    <div class="page-content">
        <div class="container-fluid">
            <div class="box-typical box-typical-padding">
                <form action="{{ route('report.expenses') }}" method="POST">
                    <div class="row">
                        <div class="col-sm-6">
                            @csrf
                            <div class="row">
                                <div class="form-group col-md-3">
                                    <label>{{__('messages.start_date')}}</label>
                                    <input type="text" class="form-control datepicker" name="sdate"
                                        value="{{ $sdate }}">
                                </div>
                                <div class="form-group col-md-3">
                                    <label>{{__('messages.end_date')}}</label>
                                    <input type="text" class="form-control datepicker" name="edate"
                                        value="{{ $edate }}">
                                </div>
                                <div class="form-group col-md-3">
                                    <label>{{__('messages.category')}}</label>
                                    <select name="expense_category" class="form-control">
                                        <option value="" selected> {{__('messages.choose')}} </option>
                                        @foreach ($expense_category as $expc)
                                            @if ($expc->category_id == $sexpense_category)
                                                <option value="{{ $expc->category_id }}" selected>{{ $expc->category_name }}
                                                </option>
                                            @else
                                                <option value="{{ $expc->category_id }}">{{ $expc->category_name }}</option>
                                            @endif
                                        @endforeach
                                    </select>
                                </div>
                                <div class="col-md-3">
                                    <button class="btn btn-purple mt-20" type="submit"> {{__('messages.submit')}}</button>
                                </div>
                            </div>
                        </div>
                        <div class="col-sm-6">
                            <div class="row">
                                @foreach ($branches as $br)
                                    @if ($branch_ids != '')
                                        @if (in_array($br->branch_id, $branch_ids))
                                            <div class="col-md-2">
                                                <input type="checkbox" name="brnchk[]" class=""
                                                    value="{{ $br->branch_id }}" checked> {{ $br->branch_name }}
                                            </div>
                                        @else
                                            <div class="col-md-2">
                                                <input type="checkbox" name="brnchk[]" class=""
                                                    value="{{ $br->branch_id }}"> {{ $br->branch_name }}
                                            </div>
                                        @endif
                                    @else
                                        <div class="col-md-2">
                                            <input type="checkbox" name="brnchk[]" class=""
                                                value="{{ $br->branch_id }}"> {{ $br->branch_name }}
                                        </div>
                                    @endif
                                @endforeach
                            </div>
                        </div>
                    </div>
                </form>
            </div>
            <div class="box-typical box-typical-padding">
                <div class="row">
                    <div class="col-md-12">
                        <table class="table MyTable" id="reportExpenseTable">
                            <thead>
                                <tr>
                                    <th>#</th>
                                    <th>{{__('messages.date')}}</th>
                                    <th>{{__('messages.branch')}}</th>
                                    <th>{{__('messages.category')}}</th>
                                    <th>{{__('messages.title')}}</th>
                                    <th>{{__('messages.notes')}}</th>
                                    <th>{{__('messages.amount')}}</th>
                                </tr>
                            </thead>
                            <tbody>
                                @php
                                    $total = 0;
                                @endphp
                                @foreach ($expenses as $exp)
                                    <tr>
                                        <td>{{ $loop->iteration }}</td>
                                        <td>{{ date('d-m-Y', strtotime($exp->exp_date)) }}</td>
                                        <td>{{ $exp->branch->branch_name??'General' }}</td>
                                        <td>{{ $exp->category->category_name??'Try'}}</td>
                                        <td>{{ $exp->title }}</td>
                                        <td>{{ $exp->notes }}</td>
                                        <td class="text-right">{{ number_format($exp->exp_amount, 3) }}</td>
                                        @php
                                            $total += $exp->exp_amount;
                                        @endphp
                                    </tr>
                                @endforeach
                            </tbody>
                            <tfoot>
                                <tr>
                                    <th>&nbsp;</th>
                                    <th>&nbsp;</th>
                                    <th>&nbsp;</th>
                                    <th>&nbsp;</th>
                                    <th>&nbsp;</th>
                                    <th>&nbsp;</th>
                                    <th>{{ $total }}</th>
                                </tr>
                            </tfoot>
                        </table>
                    </div>
                </div>
            </div><!--.container-fluid-->
            <div id="trf-details" class="modal fade" role="dialog">
                <div class="modal-dialog modal-lg">
                    <!-- Modal content-->
                    <div class="modal-content">
                        <div class="modal-header">
                            <button type="button" class="modal-close" data-dismiss="modal">
                                <i class="font-icon-close-2"></i>
                            </button>
                            <h4 class="modal-title">{{__('messages.transfer')}} # : <span id="invoice_number"></span></h4>
                        </div>
                        <div class="modal-body" id="trf-mbody">

                        </div>
                        <div class="modal-footer">
                            <button type="button" class="btn btn-default" data-dismiss="modal">{{__('messages.close')}}</button>
                        </div>
                    </div>
                </div>
            </div>
        </div><!--.page-content-->
    @endsection
    @section('customjs')
        <script src="{{ asset('custom_js/reports.js') }}"></script>
    @endsection
