function sub_total() {
	var totals = 0;
	$('.li_prd_ftotal').each(function (e) {
		totals += parseFloat($(this).text());
	});
	$('.li_srv_total').each(function (e) {
		totals += parseFloat($(this).text());
	});
	return totals;
}
function items_sub_total() {
	var totals = 0;
	$('.li_prd_total').each(function (e) {
		totals += parseFloat($(this).text());
	});
	if (isNaN(totals)) { totals = 0; }
	$('#item-subtotal').text(totals.toFixed(3));
}

function rtn_sub_total() {
	var totals = 0;
	$('.rtn_li_prd_total').each(function (e) {
		totals += parseFloat($(this).text());
	});
	return totals;
}
function grand_total() {
	var subtotal = parseFloat($('#subtotal').text());
	if (isNaN(subtotal)) { subtotal = 0; }
	var discount = parseFloat($('#discount').val());
	if (isNaN(discount)) { discount = 0; }
	$('#grandtotal').text((subtotal - discount).toFixed(3));
}
function purchase_total() {
	var totals = 0;
	$('.li_prd_pprice').each(function (e) {
		totals += parseFloat($(this).text());
	});
	return totals;
}

$(document).ready(function () {

	$('#prd_stk').focus();

	$(document).on('keypress', '.isnumber', function (e) {
		return isNumber(e, this);
	});

	$('.datepicker').datepicker({ dateFormat: 'yy-mm-dd' });

	$("#prd_stk").autocomplete({
		source: base_url + 'sales/search-prd',
		minLength: 2,
		autoFocus: true,
		focus: function (event, ui) {
			event.preventDefault();
			if (abc == 1) {
				$(this).val(ui.item.value);
				$('#prd_stk_qty').focus();
				// $('#btn-add-prd-stk-atl').trigger('click');
			}

		},
		select: function (event, ui) {
			if (abc != 1) {
				$('#prd_stk_qty').focus();
			}
		}

	});

	$('#btn-add-prd-stk-atl').on('click', function () {
		var prd_stk = $('#prd_stk').val();
		var prd_stk_qty = parseInt($('#prd_stk_qty').val());
		var flag = 0;
		if (prd_stk == "") { return false; }
		if (isNaN(prd_stk_qty)) { prd_stk_qty = 1; }
		var form_data = new FormData();
		form_data.append('prd_stk', prd_stk);
		form_data.append('prd_stk_qty', prd_stk_qty);
		$.ajax({
			url: base_url + 'sales/add-items-to-list',
			type: 'POST',
			processData: false,
			contentType: false,
			data: form_data,
			success: function (response) {
				var res = $.parseJSON(response)
				if (res['sprice'] != 'no') {
					if (res['qty'] == 'no') {
						swal('Not Enough Quantity', 'Available :' + res['stk_qty'] + ' Required : ' + prd_stk_qty, 'warning');
						flag = 1;
						return false;
					}
					else {
						$('#prd_stk_tbody').append('<tr><td></td>' +
							'<td><input type="hidden" value="' + prd_stk + '" class="li_prd_stk">' + res['stk_barcode'] + '</td>' +
							'<td>' + res['stk_name'] + '</td><td class="li_prd_avlqty">' + res['stk_qty'] + '</td>' +
							'<td><input type="text" class="form-control text-center qty_frm li_prd_qty" value="' + prd_stk_qty + '"></td>' +
							'<td class="li_prd_price">' + res['sprice'] + '</td>' +
							'<td class="li_prd_total">' + eval(prd_stk_qty * res['sprice']).toFixed(3) + '</td>' +
							'<td><input type="text" class="form-control text-center qty_frm li_prd_dis"></td>' +
							'<td class="li_prd_ftotal">' + eval(prd_stk_qty * res['sprice']).toFixed(3) + '</td>' +
							'<td><a href="#" class="tr-rmv"><i class="fa fa-close"></a></td>' +
							'</tr>');
						$('#subtotal').text(sub_total().toFixed(3));
						// $('#purchase_total').text(purchase_total().toFixed(2));
						$('#prd_stk_qty').val("");
						// $('#prd_stk_qty').focus();
						$('#prd_stk').val("");
						// $('#prd_stk').val("");
						$('#prd_stk').focus();
						var e = jQuery.Event("keydown", { keyCode: 20 });
						$("#prd_stk").trigger(e);
						items_sub_total();
						grand_total();
						recalcId();

					}
				}
				else {
					flag = 1;
				}
			}
		});
		if (flag == 1) { return false; }

		// $('#prd_stk').val("");
	});

	$('#btn-process-items-drawer').on('click', function () {
		var type = 'CASH';
		var purchases = 0;
		$('.li_prd_pprice').each(function (e) {
			var p = parseFloat($(this).text());
			var q = parseFloat($(this).closest('tr').find('.li_prd_qty').text());
			purchases += (p * q);
		});

		var subtotal = parseFloat($('#subtotal').text());
		var discount = parseFloat($('#discount').val());
		var grandtotal = parseFloat($('#grandtotal').text());
		var payments = parseFloat($('#payments').val());
		var change = parseFloat($('#change').text());

		if (isNaN(purchases)) { purchases = 0; }
		if (isNaN(subtotal)) { subtotal = 0; }
		if (isNaN(discount)) { discount = 0; }
		if (isNaN(grandtotal)) { grandtotal = 0; }
		if (isNaN(change)) { change = 0; }
		if (isNaN(payments)) { payments = 0; }
		if (subtotal == 0) {
			swal('Add Some Items', 'Please add some items to continue', 'info');
			return false;
		}
		var item_name = [];
		var item_pprice = [];
		var item_price = [];
		var item_qty = [];
		var item_total = [];
		var item_discount = [];
		var item_ftotal = [];
		$('.li_prd_stk').each(function () {

			item_name.push($(this).val());
			item_pprice.push($(this).closest('tr').find('.li_prd_pprice').text());
			item_price.push($(this).closest('tr').find('.li_prd_price').text());
			item_qty.push($(this).closest('tr').find('.li_prd_qty').val());
			item_total.push($(this).closest('tr').find('.li_prd_total').text());
			let d = $(this).closest('tr').find('.li_prd_dis').val();
			if (d == "") { d = 0; }
			item_discount.push(d);
			item_ftotal.push($(this).closest('tr').find('.li_prd_ftotal').text());
		});

		var form_data = new FormData();
		form_data.append('type', type);
		form_data.append('purchases', purchases);
		form_data.append('subtotal', subtotal);
		form_data.append('discount', discount);
		form_data.append('grandtotal', grandtotal);
		form_data.append('payments', payments);
		form_data.append('item_name', JSON.stringify(item_name));
		form_data.append('item_pprice', JSON.stringify(item_pprice));
		form_data.append('item_price', JSON.stringify(item_price));
		form_data.append('item_qty', JSON.stringify(item_qty));
		form_data.append('item_total', JSON.stringify(item_total));
		form_data.append('item_discount', JSON.stringify(item_discount));
		form_data.append('item_ftotal', JSON.stringify(item_ftotal));
		$.ajax({
			url: base_url + 'sales/process-items',
			type: 'POST',
			processData: false,
			contentType: false,
			async: false,
			data: form_data,
			success: function (response) {
				var res = $.parseJSON(response)
				if (res[0] == 1) {
					notify('success', 'Processed');
					var newWindow = window.open('testus:hello');
					newWindow.close();
					$('#prd_stk_tbody').html("");
					$('#srv_tbody').html("");
					$('#purchase_total').text('');
					$('#subtotal').text('0.000');
					$('#grandtotal').text('0.000');
					$('#payments').val('');
					$('#change').text('0.000');
					$('#prd_stk').focus();
				}
				else {
					notify('error', 'Error try again');
				}
			}
		});
	});




	var abc = 0;

	$('#prd_stk').on('keydown', function (e) {
		var v = parseInt($(this).val());
		if (e.keyCode == 13) {
			if (!isNaN(v)) {
				abc = 1;
			}
		}
		else {
			abc = 0;
		}

		// if (e.keyCode == 74 && e.ctrlKey) {
		// 	abc=1;
		// 	return false;
		//     }
	});


	$('#prd_stk_qty').on('focusin', function (e) {
		abc = 0;
	});

	$('#prd_stk_qty').on('keypress', function (e) {
		var key = e.which;
		if (key == 13) {
			$('#btn-add-prd-stk-atl').trigger('click');
		}
	});

	$("#prd_srv").autocomplete({
		source: base_url + 'sales/search_srv',
		minLength: 2
	});

	$("#rtn_prd_stk").autocomplete({
		source: base_url + 'sales/search_prd',
		minLength: 2,
		autoFocus: true,
		focus: function (event, ui) {
			event.preventDefault();
			if (abc == 1) {
				$(this).val(ui.item.value);
				$('#rtn_prd_stk_qty').focus();
				$('#btn-add-rtn-prd-stk-atl').trigger('click');
			}

		},
		select: function (event, ui) {
			if (abc != 1) {
				$('#rtn_prd_stk_qty').focus();
			}
		}
	});

	$('#rtn_prd_stk_qty').on('focusin', function (e) {
		abc = 0;
	});

	$('#rtn_prd_stk_qty').on('keypress', function (e) {
		var key = e.which;
		if (key == 13) {
			$('#btn-add-rtn-prd-stk-atl').trigger('click');
		}
	});




	$('#btn-add-srv-atl').on('click', function () {
		var prd_srv = $('#prd_srv').val();
		var srv_qty = $('#srv_qty').val();
		var flag = 0;
		if (prd_srv == "") { return false; }
		if (srv_qty == "") { return false; }
		var token_name = "<?php echo $this->security->get_csrf_token_name();?>";
		var token_value = $('#my_csrf').val();
		var form_data = new FormData();
		form_data.append('prd_srv', prd_srv);
		form_data.append(token_name, token_value);
		$.ajax({
			url: base_url + 'sales/add_srv_items_to_list',
			type: 'POST',
			processData: false,
			contentType: false,
			data: form_data,
			success: function (response) {
				var res = $.parseJSON(response)
				$('#my_csrf').val(res[0]);
				if (res[1] != 'no') {
					$('#srv_tbody').append('<tr><td></td><td class="li_prd_srv">' + prd_srv + '</td><td><span class="li_srv_qty">' + srv_qty + '</span></td><td class="li_srv_price">' + res[1] + '</td><td class="li_srv_total">' + eval(srv_qty * res[1]) + '</td><td><a href="#" class="srv-tr-rmv"><i class="fa fa-close"></a> Y</td></tr>');
					$('#subtotal').text(sub_total().toFixed(2));
					services_sub_total();
					grand_total();
					recalcId2();
				}
				else {
					flag = 1;
				}
			}
		});
		if (flag == 1) { return false; }
		$('#prd_srv').val("");
		$('#srv_qty').val("");
		$('#prd_srv').focus();
	});


	$('#btn-add-rtn-prd-stk-atl').on('click', function () {
		var prd_stk = $('#rtn_prd_stk').val();
		var prd_stk_qty = $('#rtn_prd_stk_qty').val();
		var flag = 0;
		if (prd_stk == "") { return false; }
		if (prd_stk_qty == "") { return false; }
		var token_name = "<?php echo $this->security->get_csrf_token_name();?>";
		var token_value = $('#my_csrf').val();
		var form_data = new FormData();
		form_data.append('prd_stk', prd_stk);
		form_data.append(token_name, token_value);
		$.ajax({
			url: base_url + 'sales/add_items_to_list',
			type: 'POST',
			processData: false,
			contentType: false,
			data: form_data,
			success: function (response) {
				var res = $.parseJSON(response)
				$('#my_csrf').val(res[0]);
				if (res[1] != 'no') {
					$('#rtn_prd_stk_tbody').append('<tr><td></td><td class="rtn_li_prd_stk">' + prd_stk + '</td><td>' + res[3] + '</td><td><span class="rtn_li_prd_qty">' + prd_stk_qty + '</span></td><td class="rtn_li_prd_price">' + res[1] + '</td><td class="rtn_li_prd_total">' + eval(prd_stk_qty * res[1]).toFixed(3) + '</td><td><a href="#" class="rtn-tr-rmv"><i class="fa fa-close"></a></td></tr>');
					$('#rtn_subtotal').text(rtn_sub_total().toFixed(3));
					recalcId2();
				}
				else {
					flag = 1;
				}
			}
		});
		if (flag == 1) { return false; }
		$('#rtn_prd_stk').val("");
		$('#rtn_prd_stk_qty').val("");
		$('#rtn_prd_stk').focus();
	});

	$(document).on('click', '.tr-rmv', function (e) {
		e.preventDefault();
		$(this).closest('tr').remove();
		$('#subtotal').text(sub_total().toFixed(3));
		$('#purchase_total').text(purchase_total().toFixed(3));
		recalcId();
		grand_total();
	});


	$(document).on('click', '.srv-tr-rmv', function (e) {
		e.preventDefault();
		$(this).closest('tr').remove();
		$('#subtotal').text(sub_total().toFixed(2));
		recalcId2();
		grand_total();
	});

	$(document).on('click', '.rtn-tr-rmv', function (e) {
		$(this).closest('tr').remove();
		$('#rtn_subtotal').text(rtn_sub_total().toFixed(3));
		recalcId2();
	});

	$('#customer_contact').on('keypress', function (e) {
		var key = e.which;
		if (key === 13) {
			var token_name = "<?php echo $this->security->get_csrf_token_name();?>";
			var token_value = $('#my_csrf').val();
			var form_data = new FormData();
			form_data.append('customer_contact', $(this).val());
			form_data.append(token_name, token_value);
			$.ajax({
				url: base_url + 'sales/get_customer',
				type: 'POST',
				processData: false,
				contentType: false,
				data: form_data,
				success: function (response) {
					var res = $.parseJSON(response)
					$('#my_csrf').val(res[0]);
					$('#customer_name').val(res[1]);
					$('#customer_email').val(res[2]);

				}
			});
		}
	});

	$('#customer_contact').on('blur', function (e) {
		if ($(this).val() != "") {
			$('#advance').removeAttr('readonly');
		}
		else {
			$('#advance').attr('readonly', 'readonly');
		}
	});

	$('#dpercent').on('click', function (e) {
		e.preventDefault();
		var chk = $(this).attr('title');
		if (chk == 'off') {
			$(this).attr('title', 'on');
			$(this).removeClass('text-secondary');
			$(this).addClass('text-danger');
		}
		else if (chk == 'on') {
			$(this).attr('title', 'off');
			$(this).removeClass('text-danger');
			$(this).addClass('text-secondary');
		}
		$('#discount').trigger('keyup');
	});

	$('#discount').on('keyup', function (e) {
		var sub_total = parseFloat($('#subtotal').text());
		var discount = parseFloat($(this).val());
		if (isNaN(sub_total)) { sub_total = 0; }
		if (isNaN(discount)) { discount = 0; }
		var distchk = $('#dpercent').attr('title');
		// alert(distchk);
		if (distchk == 'on') {
			var discount_amount = ((sub_total * discount) / 100);
			var grandtotal = (sub_total - discount_amount);
		}
		else if (distchk == 'off') {
			var grandtotal = (sub_total - discount);
		}
		$('#grandtotal').text(grandtotal.toFixed(3));
	});

	$('#payments').on('keyup', function (e) {
		var grandtotal = parseFloat($('#grandtotal').text());
		var payments = parseFloat($(this).val());

		if (isNaN(grandtotal)) { grandtotal = 0; }
		if (isNaN(payments)) { payments = 0; }
		var change = (grandtotal - payments).toFixed(2);
		$('#change').text(change);
	});

	$('#payment_type').on('change', function (e) {
		if ($(this).val() == 'cheque') {
			$('#row_cheque').removeClass('hidden');
		}
		else {
			$('#row_cheque').addClass('hidden');
		}
	});

	$('#btn-process-items').on('click', function () {
		var customer_contact = $('#customer_contact').val();
		var customer_name = $('#customer_name').val();
		var customer_email = $('#customer_email').val();
		var payment_type = $('#payment_type').val();
		var cheque_number = $('#cheque_number').val();
		var notes = $('#notes').val();
		var type = 'CASH';
		if (customer_contact != "") {
			type = 'CUSTOMER';
		}
		if (type == 'CUSTOMER' && customer_name == "") {
			swal('Customer Name Required', 'Please add customer name if using contact', 'info');
			return false;
		}
		var purchases = 0;
		$('.li_prd_pprice').each(function (e) {
			var p = parseFloat($(this).text());
			var q = parseFloat($(this).closest('tr').find('.li_prd_qty').text());
			purchases += (p * q);
		});

		var itm_subtotal = parseFloat($('#item-subtotal').text());
		var subtotal = parseFloat($('#subtotal').text());
		var discount = parseFloat($('#discount').val());
		var grandtotal = parseFloat($('#grandtotal').text());
		var advance = parseFloat($('#advance').val());
		var payments = parseFloat($('#payments').val());
		var change = parseFloat($('#change').text());




		if (isNaN(purchases)) { purchases = 0; }
		if (isNaN(subtotal)) { subtotal = 0; }
		if (isNaN(discount)) { discount = 0; }
		if (isNaN(grandtotal)) { grandtotal = 0; }
		if (isNaN(change)) { change = 0; }
		if (isNaN(payments)) { payments = 0; }
		if (subtotal == 0) {
			swal('Add Some Items', 'Please add some items to continue', 'info');
			return false;
		}
		// if(discount>subtotal)
		// {
		// 	swal('Discount Limit','Discount must be equals or less subtotal','warning');
		// 	return false;
		// }
		if (payment_type == "") {
			swal('Payment Type', 'Please choose a payment type', 'info');
			return false;
		}

		if (payment_type == 'cheque' && cheque_number == "") {
			swal('Cheque Number', 'Cheque Number required when using cheque', 'info');
			return false;
		}
		// if(payments<grandtotal && customer_contact=="")
		// {
		// 	swal('Warning','Payment must be equals to grand total','warning');
		// 	return false;
		// }

		var item_name = [];
		var item_pprice = [];
		var item_price = [];
		var item_qty = [];
		var item_total = [];
		var item_discount = [];
		var item_ftotal = [];
		$('.li_prd_stk').each(function () {
			item_name.push($(this).val());
			item_pprice.push($(this).closest('tr').find('.li_prd_pprice').text());
			item_price.push($(this).closest('tr').find('.li_prd_price').text());
			item_qty.push($(this).closest('tr').find('.li_prd_qty').val());
			item_total.push($(this).closest('tr').find('.li_prd_total').text());
			item_discount.push($(this).closest('tr').find('.li_prd_dis').val());
			item_ftotal.push($(this).closest('tr').find('.li_prd_ftotal').text());
		});

		var service_name = [];
		var service_price = [];
		var service_qty = [];
		var service_total = [];
		$('.li_prd_srv').each(function () {
			service_name.push($(this).text());
			service_price.push($(this).closest('tr').find('.li_srv_price').text());
			service_qty.push($(this).closest('tr').find('.li_srv_qty').text());
			service_total.push($(this).closest('tr').find('.li_srv_total').text());
		});



		var token_name = "<?php echo $this->security->get_csrf_token_name();?>";
		var token_value = $('#my_csrf').val();
		var form_data = new FormData();
		form_data.append('type', type);
		form_data.append('customer_contact', customer_contact);
		form_data.append('customer_name', customer_name);
		form_data.append('customer_email', customer_email);
		form_data.append('purchases', purchases);
		form_data.append('subtotal', subtotal);
		form_data.append('payment_type', payment_type);
		form_data.append('cheque_number', cheque_number);
		form_data.append('discount', discount);
		form_data.append('grandtotal', grandtotal);
		form_data.append('advance', advance);
		form_data.append('payments', payments);
		form_data.append('change', change);
		form_data.append('notes', notes);
		form_data.append('item_name', JSON.stringify(item_name));
		form_data.append('item_pprice', JSON.stringify(item_pprice));
		form_data.append('item_price', JSON.stringify(item_price));
		form_data.append('item_qty', JSON.stringify(item_qty));
		form_data.append('item_total', JSON.stringify(item_total));
		form_data.append('item_discount', JSON.stringify(item_discount));
		form_data.append('item_ftotal', JSON.stringify(item_ftotal));
		form_data.append(token_name, token_value);
		$.ajax({
			url: base_url + 'sales/process_items',
			type: 'POST',
			processData: false,
			contentType: false,
			async: false,
			data: form_data,
			success: function (response) {
				var res = $.parseJSON(response)
				$('#my_csrf').val(res[0]);
				if (res[1] == 1) {
					$('#ifnotify-success').text(' Processed');
					$('#ifnotify-success').trigger('click');
					window.open(base_url + 'sales/invoice/' + res[2]);
					$('#prd_stk_tbody').html("");
					$('#srv_tbody').html("");
					$('#purchase_total').text('');
					$('#customer_contact').val('');
					$('#customer_name').val('');
					$('#customer_email').val('');
					$('#item-subtotal').text('0.000');
					$('#subtotal').text('0.000');
					$('#payment_type').val('cash');
					$('#cheque_number').val('');
					$('#grandtotal').text('0.000');
					$('#discount').val('');
					$('#advance').val('');
					$('#advance').attr('readonly', 'readonly');
					$('#payments').val('');
					$('#change').text('0.000');
					$('#prd_stk').focus();
				}
				else {
					$('#ifnotify-error').text(' Error try again');
					$('#ifnotify-error').trigger('click');
				}
			}
		});
	});

	$('#btn-test').on('click', function (e) {
		var newWindow = window.open('testus:hello');
		// newWindow.close();
	});



	$('#btn-rtn-items').on('click', function () {
		var rtn_invoice = $('#rtn_invoice').val();
		var subtotal = parseFloat($('#rtn_subtotal').text());
		if (isNaN(subtotal)) { subtotal = 0; }
		if (isNaN(subtotal) || subtotal == 0) {
			swal('No Items', 'Please add items', 'info');
			return false;
		}

		var item_name = [];
		var item_price = [];
		var item_qty = [];
		var item_total = [];
		$('.rtn_li_prd_stk').each(function () {
			item_name.push($(this).text());
			item_price.push($(this).closest('tr').find('.rtn_li_prd_price').text());
			item_qty.push($(this).closest('tr').find('.rtn_li_prd_qty').text());
			item_total.push($(this).closest('tr').find('.rtn_li_prd_total').text());
		});
		var token_name = "<?php echo $this->security->get_csrf_token_name();?>";
		var token_value = $('#my_csrf').val();
		var form_data = new FormData();
		form_data.append('rtn_invoice', rtn_invoice);
		form_data.append('subtotal', subtotal);
		form_data.append('item_name', JSON.stringify(item_name));
		form_data.append('item_price', JSON.stringify(item_price));
		form_data.append('item_qty', JSON.stringify(item_qty));
		form_data.append('item_total', JSON.stringify(item_total));
		form_data.append(token_name, token_value);
		$.ajax({
			url: base_url + 'sales/process_return_items',
			type: 'POST',
			processData: false,
			contentType: false,
			data: form_data,
			success: function (response) {
				var res = $.parseJSON(response)
				$('#my_csrf').val(res[0]);
				if (res[1] == 1) {
					$('#ifnotify-success').text(' Processed');
					$('#ifnotify-success').trigger('click');
					$('#rtn_invoice').val("");
					$('#rtn_prd_stk_tbody').html("");
					$('#rtn_subtotal').text('0.00');
				}
				else {
					$('#ifnotify-error').text(' Error try again');
					$('#ifnotify-error').trigger('click');
				}
			}
		});
	});

	$('#rtn_invoice').on('keypress', function (e) {
		var key = e.which;
		if (key === 13) {
			var invnumber = $(this).val();
			var invoice = 'INVOICE-' + invnumber;
			$('#return-inovice-modal').modal('toggle');
			$('#inv-iframe').attr('src', base_url + 'sales/invoice/' + invoice);
		}
	});

	$('#btn-process-quotation').on('click', function () {
		var customer_contact = $('#customer_contact').val();
		var customer_name = $('#customer_name').val();
		var type = 'CUSTOMER';
		if (customer_name == "") {
			swal('Customer Name Required', 'Please add customer name if using contact', 'info');
			return false;
		}
		if (customer_contact == "") {
			swal('Customer Contact Required', 'Please add customer contact', 'warning');
			return false;
		}

		var purchases = 0;
		$('.li_prd_pprice').each(function (e) {
			var p = parseFloat($(this).text());
			var q = parseFloat($(this).closest('tr').find('.li_prd_qty').text());
			purchases += (p * q);
		});

		var subtotal = parseFloat($('#subtotal').text());
		var discount = parseFloat($('#discount').val());
		var grandtotal = parseFloat($('#grandtotal').text());
		var advance = parseFloat($('#advance').val());
		var payments = parseFloat($('#payments').val());
		var change = parseFloat($('#change').text());

		if (isNaN(purchases)) { purchases = 0; }
		if (isNaN(subtotal)) { subtotal = 0; }
		if (isNaN(discount)) { discount = 0; }
		if (isNaN(grandtotal)) { grandtotal = 0; }
		if (isNaN(change)) { change = 0; }
		if (isNaN(payments)) { payments = 0; }
		if (subtotal == 0) {
			swal('Add Some Items', 'Please add some items to continue', 'info');
			return false;
		}
		if (discount > subtotal) {
			swal('Discount Limit', 'Discount must be equals or less subtotal', 'warning');
			return false;
		}

		var item_name = [];
		var item_pprice = [];
		var item_price = [];
		var item_qty = [];
		var item_total = [];
		$('.li_prd_stk').each(function () {
			item_name.push($(this).text());
			item_pprice.push($(this).closest('tr').find('.li_prd_pprice').text());
			item_price.push($(this).closest('tr').find('.li_prd_price').text());
			item_qty.push($(this).closest('tr').find('.li_prd_qty').text());
			item_total.push($(this).closest('tr').find('.li_prd_total').text());
		});
		var token_name = "<?php echo $this->security->get_csrf_token_name();?>";
		var token_value = $('#my_csrf').val();
		var form_data = new FormData();
		form_data.append('type', type);
		form_data.append('customer_contact', customer_contact);
		form_data.append('customer_name', customer_name);
		form_data.append('purchases', purchases);
		form_data.append('subtotal', subtotal);
		form_data.append('discount', discount);
		form_data.append('grandtotal', grandtotal);
		form_data.append('advance', advance);
		form_data.append('payments', payments);
		form_data.append('change', change);
		form_data.append('item_name', JSON.stringify(item_name));
		form_data.append('item_pprice', JSON.stringify(item_pprice));
		form_data.append('item_price', JSON.stringify(item_price));
		form_data.append('item_qty', JSON.stringify(item_qty));
		form_data.append('item_total', JSON.stringify(item_total));
		form_data.append(token_name, token_value);
		$.ajax({
			url: base_url + 'sales/process_quotation',
			type: 'POST',
			processData: false,
			contentType: false,
			async: false,
			data: form_data,
			success: function (response) {
				var res = $.parseJSON(response)
				$('#my_csrf').val(res[0]);
				if (res[1] == 1) {
					$('#ifnotify-success').text(' Processed');
					$('#ifnotify-success').trigger('click');
					window.open(base_url + 'sales/qinvoice/' + res[2]);
					$('#prd_stk_tbody').html("");
					$('#purchase_total').text('');
					$('#customer_contact').val('');
					$('#customer_name').val('');
					$('#subtotal').text('0.00');
					$('#grandtotal').text('0.00');
					$('#discount').val('');
					$('#advance').val('');
					$('#advance').attr('readonly', 'readonly');
					$('#payments').val('');
					$('#change').text('0.00');
				}
				else {
					$('#ifnotify-error').text(' Error try again');
					$('#ifnotify-error').trigger('click');
				}
			}
		});
	});

	$('#show-stock-modal').on('show.bs.modal', function (e) {
		$('#salesStkItemsTable').DataTable().destroy();
		$('#salesStkItemsTable').DataTable({
			ajax: {
				url: base_url + 'sales/show-stock-items',
				type: "GET", // or 'POST' if needed
			},
			language: {
				lengthMenu: "_MENU_",
			},
			pageLength: 100,
			order: [],
			responsive: true,
		});
	});

	$(document).on('keyup', '.li_prd_qty', function (e) {
		var key = e.which;
		// if(key==13)
		// {
		var qty = parseInt($(this).val());
		var avl = parseInt($(this).closest('tr').find('.li_prd_avlqty').text());
		var upr = parseFloat($(this).closest('tr').find('.li_prd_price').text());
		var dis = parseFloat($(this).closest('tr').find('.li_prd_dis').val());
		var disc = 0;
		if (isNaN(qty)) { qty = 0; }
		if (isNaN(avl)) { avl = 0; }
		if (isNaN(upr)) { upr = 0; }
		if (qty > avl) {
			swal('Not Enough Quantity', 'Available :' + avl + ' Required : ' + qty, 'warning');
			$(this).val(avl);
			return false;
		}
		else {
			var tot = (qty * upr);
			if (dis != 0) {
				var disc = ((tot * dis) / 100);
			}
			if (isNaN(disc)) { disc = 0; }
			$(this).closest('tr').find('.li_prd_total').text(tot.toFixed(3));
			$(this).closest('tr').find('.li_prd_ftotal').text((tot - disc).toFixed(3));

			$('#subtotal').text(sub_total().toFixed(3));
			grand_total();
		}
		// }

	});

	$(document).on('keyup', '.li_prd_dis', function (e) {
		var key = e.which;
		// if(key==13)
		// {
		var tot = parseFloat($(this).closest('tr').find('.li_prd_total').text());
		var dis = parseFloat($(this).val());
		var disc = 0;
		if (isNaN(tot)) { tot = 0; }
		if (isNaN(dis)) { dis = 0; }
		if (dis != 0) {
			var disc = ((tot * dis) / 100);
		}
		$(this).closest('tr').find('.li_prd_ftotal').text((tot - disc).toFixed(3));
		$('#subtotal').text(sub_total().toFixed(3));
		grand_total();

		// }

	});

	$('#notes-modal').on('show.bs.modal', function (e) {
		$.ajax({
			url: base_url + 'sales/get-rmd-notes',
			type: 'POST',
			success: function (response) {
				$('#rmd_notes').val(response);
			}
		});
	});

	$('#btn-save-notes').on('click', function (e) {
		var rmd_notes = $('#rmd_notes').val();
		$.ajax({
			url: base_url + 'sales/save-rmd-notes',
			type: 'POST',
			data: { rmd_notes: rmd_notes },
			success: function (response) {
				if (response == 1) {
					notify('success', 'Notes Saved Successfully');
				}
				else {
					notify('error', 'Error try again');
				}
			}
		});
	});

	// $(document).on('keydown',function(e){
	// 	var key = e.which;
	// 	if(key==49)
	// 	{
	// 		e.preventDefault();
	// 		$('#discount').focus();
	// 	}
	// 	if(key==50)
	// 	{
	// 		e.preventDefault();
	// 		$('#payments').focus();
	// 	}
	// 	if(key==51)
	// 	{
	// 		e.preventDefault();
	// 		$('#btn-process-items-drawer').trigger('click');
	// 	}
	// 	if(key==52)
	// 	{
	// 		e.preventDefault();
	// 		$('#btn-process-items').trigger('click');
	// 	}

	// });

});// End Ready Function
