$.ajaxSetup({
    headers: { "X-CSRF-TOKEN": $('meta[name="csrf-token"]').attr("content") },
});

function isNumber(evt, element) {
    var charCode = evt.which ? evt.which : event.keyCode;
    if (
        (charCode != 45 || $(element).val().indexOf("-") != -1) &&
        (charCode != 46 || $(element).val().indexOf(".") != -1) &&
        ((charCode < 48 && charCode != 8) || charCode > 57)
    ) {
        return false;
    } else {
        return true;
    }
}

function recalcId() {
    $.each($(".sr tr:not(:first)"), function (i, el) {
        $(this)
            .find("td:first")
            .text(i + 1);
    });
}

function recalcId2() {
    $.each($(".sr2 tr:not(:first)"), function (i, el) {
        $(this)
            .find("td:first")
            .text(i + 1);
    });
}
function recalcId3() {
    $.each($(".sr3 tr:not(:first)"), function (i, el) {
        $(this)
            .find("td:first")
            .text(i + 1);
    });
}

function clear(selector) {
    $(selector).html("");
    $(selector).val("");
    $(selector).text("");
}

function prevent_tabs_on_refresh() {
    if (location.hash) {
        $("a[href='" + location.hash + "']").tab("show");
    }
    var activeTab = localStorage.getItem("activeTab");
    if (activeTab) {
        $('a[href="' + activeTab + '"]').tab("show");
    }

    $("body").on("click", "a[data-toggle='tab']", function (e) {
        e.preventDefault();
        var tab_name = this.getAttribute("href");
        if (history.pushState) {
            history.pushState(null, null, tab_name);
        } else {
            location.hash = tab_name;
        }
        localStorage.setItem("activeTab", tab_name);

        $(this).tab("show");
        return false;
    });
    $(window).on("popstate", function () {
        var anchor =
            location.hash || $("a[data-toggle='tab']").first().attr("href");
        $("a[href='" + anchor + "']").tab("show");
    });
}

function show_ifmsgs(selector, error_msg, type) {
    if (type == "success") {
        $(
            '<p class="iferrors help-block text-success" style="color:green;">' +
                error_msg +
                "</p>"
        )
            .hide()
            .fadeIn("slow")
            .insertAfter(selector);
    }
    if (type == "info") {
        $(
            '<p class="iferrors help-block text-info" style="color:blue;">' +
                error_msg +
                "</p>"
        )
            .hide()
            .fadeIn("slow")
            .insertAfter(selector);
    }
    if (type == "warning") {
        $(
            '<p class="iferrors help-block text-warning" style="color:orange;">' +
                error_msg +
                "</p>"
        )
            .hide()
            .fadeIn("slow")
            .insertAfter(selector);
    }
    if (type == "error") {
        $(
            '<p class="iferrors help-block text-danger" style="color:red;">' +
                error_msg +
                "</p>"
        )
            .hide()
            .fadeIn("slow")
            .insertAfter(selector);
    }
}
function hide_ifmsgs() {
    $(".iferrors").remove();
}
function generate_required(form) {
    var flag = 0;
    $(form + " .clrreq").remove();
    $(form + " .ifrequired").each(function () {
        var id = $(this).attr("id");
        var selector = "#" + id;
        if ($(selector).val() == "") {
            $(
                '<p class="clrreq help-block text-red" style="color:red;">*Required</p>'
            )
                .hide()
                .fadeIn("slow")
                .insertAfter(selector);
            flag++;
        }
    });
    if (flag > 0) {
        return "yes";
    }
}

notify = (ntype = "default", ntext = "Message") => {
    switch (ntype) {
        case "default":
            head = "Default";
			lbg  ="#adb7be";
            break;
        case "info":
            head = "Info";
			lbg  ="#00a8ff";
            break;
        case "success":
            head = 'Success';
			lbg ='#46c35f';
            break;
        case "warning":
			head="Warning";
			lbg ='#fdad2a'
            break;
        case "error":
			head="Error";
			lbg='#fa424a';
            break;
    }

    $.toast({
        heading: head,
        text: ntext,
        showHideTransition: "slide",
        icon: ntype,
        loaderBg: lbg,
        position: "top-center",
    });
};

function showTime(){
  // to get current time/ date.
  var date = new Date();
  // to get the current hour
  var h = date.getHours();
    // to get the current minutes
  var m = date.getMinutes();
  //to get the current second
  var s = date.getSeconds();
  // AM, PM setting
  var session = "AM"; 
  
 //conditions for times behavior 
  if ( h == 0 ) {
    h = 12;
  }
  if( h >= 12 ){
     session = "PM";
     }
  
  if ( h > 12 ){
    h = h - 12;
  }
  m = ( m < 10 ) ? m = "0" + m : m;
  s = ( s < 10 ) ? s = "0" + s : s;
  
  //putting time in one variable
  var time = h + ":" + m + ":" + s + " " + session;
  //putting time in our div
  $('#clock').html(time); 
  //to change time in every seconds
  setTimeout( showTime, 1000 );
}

$(document).ready(function (e) {
    $(document).on("keypress", ".isnumber", function (e) {
        return isNumber(e, this);
    });
    showTime();
    $(document).on("keydown", function (e) {
        if (e.keyCode == 74 && e.ctrlKey) {
            return false;
        }
    });

    $(".datepicker").datepicker({ dateFormat: "yy-mm-dd" });
    $("#change-password-modal").on("show.bs.modal", function (e) {
        $("#change_password_err_msg").text("");
        $("#user_old_password").val("");
        $("#user_new_password").val("");
    });
    $("#btn_change_user_password").on("click", function (e) {
        var user_old_password = $("#user_old_password").val();
        var user_new_password = $("#user_new_password").val();
        if (user_old_password == "") {
            $("#change_password_err_msg").text("Required").css("color", "red");
            $("#user_old_password").focus();
            return false;
        }
        if (user_old_password == "") {
            $("#change_password_err_msg").text("Required").css("color", "red");
            $("#user_new_password").focus();
            return false;
        }
        var form_data = new FormData();
        form_data.append("user_old_password", user_old_password);
        form_data.append("user_new_password", user_new_password);
        $.ajax({
            url: base_url + "misc/change_password",
            type: "POST",
            processData: false,
            contentType: false,
            data: form_data,
            success: function (response) {
                if (response == 1) {
                    $("#ifnotify-success").text(" Passowrd Changed");
                    $("#ifnotify-success").trigger("click");
                } else if (response == 2) {
                    $("#ifnotify-warning").text(" Invalid Old Password");
                    $("#ifnotify-warning").trigger("click");
                } else if (response == 0) {
                    $("#ifnotify-error").text(" Error try again later!");
                    $("#ifnotify-error").trigger("click");
                }
            },
        });
    });

    // $('#notificationsTable').DataTable({
    // 	 "sAjaxSource": base_url+'misc/show_all_notifications',
    // 	 "pageLength": 100,
    // 	 "order": [],
    // 	 "responsive":true
    // });

    $body = $("body");

    $(document).on({
        ajaxStart: function () {
            $body.addClass("loading");
        },
        ajaxStop: function () {
            $body.removeClass("loading");
        },
    });
});
