function if_ajax_request(rurl, data, viewer, cmsg, cdata, dt) {
	dataString = data;
	var jsonString = JSON.stringify(dataString);
	$.ajax({
		type: "POST",
		url: base_url + rurl,
		data: { data: jsonString },
		cache: false,
		success: function (response) {
			if (response == 1) {
				$('#ifnotify-success').text(' Added');
				$('#ifnotify-success').trigger('click');
				$.each(cdata, function (index, value) {
					clear(value);
				});
				$(dt).DataTable().ajax.reload();
			}
			else if (response == 0) {
				$('#ifnotify-error').text(' Error try again');
				$('#ifnotify-error').trigger('click');
			}
			else if (response == 2) {
				$('#ifnotify-warning').text(' Already Exists');
				$('#ifnotify-warning').trigger('click');
			}
		}
	});
}
$(document).ready(function () {
	// Datepicker 
	$('.datepicker').datepicker({ dateFormat: 'yy-mm-dd' });
	
	$('#expensesTable').DataTable({
		ajax: {
            url: base_url + "expense/show",
            type: "GET", // or 'POST' if needed
        },
        language: {
            lengthMenu: "_MENU_",
        },
        pageLength: 100,
        order: [],
        responsive: true,
	});
	
	$('#btn_add_expense').on('click', function () {
		$('#exp_err_msg').html("");
		if ($('#expense_category').val() == "") {
			$('#exp_err_msg').html("Please Choose a Category").css('color', 'red');
		}
		else if ($('#expense_branch').val() == "") {
			$('#exp_err_msg').html("Please Choose a Branch").css('color', 'red');
		}
		else if ($('#expense_subcategory').val() == "") {
			$('#exp_err_msg').html("Please Choose a Sub Category").css('color', 'red');
		}
		else if ($('#expense_title').val() == "") {
			$('#exp_err_msg').html("Please Enter Title").css('color', 'red');
			$('#expense_title').focus();
		}
		else if ($('#expense_date').val() == "") {
			$('#exp_err_msg').html("Please Enter Date").css('color', 'red');
			$('#expense_date').focus();
		}
		else if ($('#expense_amount').val() == "") {
			$('#exp_err_msg').html("Please Enter Amount").css('color', 'red');
			$('#expense_amount').focus();
		}
		else if ($('#payment_type').val() == "") {
			$('#exp_err_msg').html("Please Choose Payment Type").css('color', 'red');
			$('#payment_type').focus();
		}
		else if ($('#payment_type').val() == 'cheque' && $('#cheque_number').val() == "") {
			$('#exp_err_msg').html("Please Enter Cheque Number if Using Cheque").css('color', 'red');
			$('#cheque_number').focus();
		}
		else {
			var branch_id = $('#expense_branch').val();
			var category = $('#expense_category').val();
			var subcategory = $('#expense_subcategory').val();
			var title = $('#expense_title').val();
			var date = $('#expense_date').val();
			var amount = $('#expense_amount').val();
			var payment_type = $('#payment_type').val();
			var cheque_number = $('#cheque_number').val();
			var notes = $('#expense_notes').val();
			$.ajax({
				url: base_url + 'expense/add',
				type: 'POST',
				data: { branch_id: branch_id, category: category, subcategory: subcategory, title: title, date: date, amount: amount, payment_type: payment_type, cheque_number: cheque_number, notes: notes },
				success: function (response) {
					if (response == 1) {
						notify('success', 'Expense Added Successfully');
						$('#expensesTable').DataTable().ajax.reload();
						$('#expense_title').val("");
						$('#expense_date').val("");
						$('#expense_amount').val("");
						$('#expense_notes').val("");
						$('#expense_branch').val("");
						$('#expense_category').val("");
						$('#expense_subcategory').val("");
						$('#payment_type').val("");
						$('#cheque_number').val("");
					}
					else {
						notify('error', 'Error Adding Expense');
					}
				}
			});
		}
	});

	$('#expense-edit-modal').on('show.bs.modal', function (e) {
		var exp_id = e.relatedTarget.id;
		$('#e_exp-msg').html("");
		$('#e_exp_id').val(exp_id);
		$.ajax({
			url: base_url + 'expense/edit',
			type: 'POST',
			data: { exp_id: exp_id },
			success: function (msg) {
				var res = $.parseJSON(msg);
				$('#e_expense_branch').val(res[0]);
				$('#e_expense_category').val(res[1]);
				$('#e_expense_title').val(res[3]);
				$('#e_expense_date').val(res[4]);
				$('#e_expense_amount').val(res[5]);
				$('#e_expense_notes').val(res[6]);
			}
		});
	});
	$('#btn_update_expense').on('click', function () {
		$('#e_exp_err_msg').html("");
		if ($('#e_expense_category').val() == "") {
			$('#e_exp_err_msg').html("Please Choose a Category").css('color', 'red');
		}
		else if ($('#e_expense_branch').val() == "") {
			$('#e_exp_err_msg').html("Please Choose a Branch").css('color', 'red');
		}
		else if ($('#e_expense_title').val() == "") {
			$('#e_exp_err_msg').html("Please Enter Title").css('color', 'red');
			$('#e_expense_title').focus();
		}
		else if ($('#e_expense_date').val() == "") {
			$('#e_exp_err_msg').html("Please Enter Date").css('color', 'red');
			$('#e_expense_date').focus();
		}
		else if ($('#e_expense_amount').val() == "") {
			$('#e_exp_err_msg').html("Please Enter Amount").css('color', 'red');
			$('#e_expense_amount').focus();
		}
		else {

			var exp_id = $('#e_exp_id').val();
			var branch_id = $('#e_expense_branch').val();
			var category = $('#e_expense_category').val();
			var title = $('#e_expense_title').val();
			var date = $('#e_expense_date').val();
			var amount = $('#e_expense_amount').val();
			var notes = $('#e_expense_notes').val();
			$.ajax({
				url: base_url + 'expense/update',
				type: 'POST',
				data: { exp_id: exp_id, branch_id: branch_id, category: category, title: title, date: date, amount: amount, notes: notes },
				success: function (response) {
					if (response == 1) {
						notify('success', 'Expense Updated Successfully');
						$('#expensesTable').DataTable().ajax.reload();
					}
					else if (response == 2) {
						notify('warning', 'Nothing to update');
					}
					else {
						notify('error', 'Error Updating Expense');
					}
				}
			});
		}
	});
	$("#expensesTable").on("click", ".ifdel", function (e) {
        e.preventDefault();
        exp_id = $(this).attr("data-uid");
        swal(
            {
                title: "Are you sure?",
                text: "You will not be able to recover this data!",
                type: "warning",
                showCancelButton: true,
                confirmButtonClass:
                    "btn-danger btn-md waves-effect waves-light",
                confirmButtonColor: "#DD6B55",
                confirmButtonText: "Yes, delete it!",
                cancelButtonText: "No, cancel it!",
                closeOnConfirm: true,
                closeOnCancel: true,
            },
            function (isConfirm) {
                if(isConfirm){
                    $.ajax({
                        url: base_url + "expense/delete",
                        type: "POST",
                        data: { exp_id: exp_id },
                        success: function (response) {
                            if (response == 1) {
                                notify("success", "Deleted");
                            } else {
                                notify("error", "Error deleting please try again");
                            }
                        },
                        error: function (msg) {
                            let res_errors = "";
                            $.each(msg.responseJSON.errors, function (key, value) {
                                res_errors += value + "<br>";
                            });
                            notify("warning", res_errors);
                        },
                    }); //End of Ajax Request
                    $("#expensesTable").DataTable().ajax.reload();
                }
            }
        );
    });
   
	
});// End Ready Function
