<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class ExpenseCategory extends Model
{
    protected $primaryKey='category_id';
    protected $table = 'expense_category';
    public $timestamps = false;
    protected $fillable = [
        'category_name',
        'dated',
        'in_user'
    ];
    public function expenses()
    {
        return $this->hasMany(Expenses::class, 'category', 'category_id');
    }
}
