<?php

namespace App\Http\Controllers;

use App\Models\Expenses;
use App\Models\Purchases;
use App\Models\Sales;
use Illuminate\Http\Request;

class DashboardController extends Controller
{
    public function index()
    {
      
        $sales = Sales::selectRaw("
        SUM(CASE WHEN DATE(dated) = CURDATE() THEN grand_total ELSE 0 END) as daily,
        SUM(CASE WHEN MONTH(dated) = MONTH(CURDATE()) AND YEAR(dated) = YEAR(CURDATE()) THEN grand_total ELSE 0 END) as monthly,
        SUM(grand_total) as total")->first();

        $purchases = Purchases::selectRaw("
        SUM(CASE WHEN DATE(purchase_date) = CURDATE() THEN sub_total ELSE 0 END) as daily,
        SUM(CASE WHEN MONTH(purchase_date) = MONTH(CURDATE()) AND YEAR(purchase_date) = YEAR(CURDATE()) THEN sub_total ELSE 0 END) as monthly,
        SUM(sub_total) as total")->first();
        
        $expenses = Expenses::selectRaw("
        SUM(CASE WHEN DATE(exp_date) = CURDATE() THEN exp_amount ELSE 0 END) as daily,
        SUM(CASE WHEN MONTH(exp_date) = MONTH(CURDATE()) AND YEAR(exp_date) = YEAR(CURDATE()) THEN exp_amount ELSE 0 END) as monthly,
        SUM(exp_amount) as total")->first();

        $lastTenSales = Sales::with('salesDetails')->orderBy('dated', 'desc')->take(10)->get();
        $data=['sales'=>$sales,'purchases'=>$purchases,'expenses'=>$expenses,'lastTenSales'=>$lastTenSales];

        
        
        return view('admin.dashboard',$data);
    }
}
