<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <title>Big Wishes | Admin & POS Portal Selection</title>
  <script src="https://cdn.tailwindcss.com"></script>
  <style>
    @import  url('https://fonts.googleapis.com/css2?family=Inter:wght@400;600;700&display=swap');
    html {
      font-family: 'Inter', sans-serif;
      background-color: #f9f5f0;
      background-image: url("data:image/svg+xml,%3Csvg width='100' height='100' viewBox='0 0 100 100' xmlns='http://www.w3.org/2000/svg'%3E%3Cpath d='M11 18c3.866 0 7-3.134 7-7s-3.134-7-7-7-7 3.134-7 7 3.134 7 7 7zm48 25c3.866 0 7-3.134 7-7s-3.134-7-7-7-7 3.134-7 7 3.134 7 7 7zm-43-7c1.657 0 3-1.343 3-3s-1.343-3-3-3-3 1.343-3 3 1.343 3 3 3zm63 31c1.657 0 3-1.343 3-3s-1.343-3-3-3-3 1.343-3 3 1.343 3 3 3zM34 90c1.657 0 3-1.343 3-3s-1.343-3-3-3-3 1.343-3 3 1.343 3 3 3zm56-76c1.657 0 3-1.343 3-3s-1.343-3-3-3-3 1.343-3 3 1.343 3 3 3zM12 86c2.21 0 4-1.79 4-4s-1.79-4-4-4-4 1.79-4 4 1.79 4 4 4zm28-65c2.21 0 4-1.79 4-4s-1.79-4-4-4-4 1.79-4 4 1.79 4 4 4zm23-11c2.76 0 5-2.24 5-5s-2.24-5-5-5-5 2.24-5 5 2.24 5 5 5zm-6 60c2.21 0 4-1.79 4-4s-1.79-4-4-4-4 1.79-4 4 1.79 4 4 4zm29 22c2.76 0 5-2.24 5-5s-2.24-5-5-5-5 2.24-5 5 2.24 5 5 5zM32 63c2.76 0 5-2.24 5-5s-2.24-5-5-5-5 2.24-5 5 2.24 5 5 5zm57-13c2.76 0 5-2.24 5-5s-2.24-5-5-5-5 2.24-5 5 2.24 5 5 5zm-9-21c1.105 0 2-.895 2-2s-.895-2-2-2-2 .895-2 2 .895 2 2 2zM60 91c1.105 0 2-.895 2-2s-.895-2-2-2-2 .895-2 2 .895 2 2 2zM35 41c1.105 0 2-.895 2-2s-.895-2-2-2-2 .895-2 2 .895 2 2 2zM12 60c1.105 0 2-.895 2-2s-.895-2-2-2-2 .895-2 2 .895 2 2 2z' fill='%23e2d5c3' fill-opacity='0.3' fill-rule='evenodd'/%3E%3C/svg%3E");
    }
    .animate-float {
      animation: float 6s ease-in-out infinite;
    }
    @keyframes  float {
      0%, 100% { transform: translateY(0); }
      50% { transform: translateY(-10px); }
    }
  </style>
</head>
<body class="min-h-screen flex items-center justify-center p-4">
  <!-- Animated background elements -->
  <div class="fixed inset-0 overflow-hidden -z-10">
    <div class="absolute top-20 left-20 w-40 h-40 rounded-full bg-amber-100 opacity-20 blur-xl animate-float"></div>
    <div class="absolute bottom-20 right-20 w-60 h-60 rounded-full bg-indigo-100 opacity-20 blur-xl animate-float" style="animation-delay: 2s;"></div>
  </div>

  <div class="text-center w-full max-w-4xl">
    <!-- Logo Header -->
    <div class="flex justify-center mb-6">
      <div class="bg-white p-4 rounded-2xl shadow-md inline-flex items-center">
        <svg xmlns="http://www.w3.org/2000/svg" class="h-10 w-10 text-indigo-600 mr-3" fill="none" viewBox="0 0 24 24" stroke="currentColor">
          <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 3v2m6-2v2M9 19v2m6-2v2M5 9H3m2 6H3m18-6h-2m2 6h-2M7 19h10a2 2 0 002-2V7a2 2 0 00-2-2H7a2 2 0 00-2 2v10a2 2 0 002 2zM9 9h6v6H9V9z" />
        </svg>
        <span class="text-2xl font-bold bg-gradient-to-r from-indigo-600 to-blue-600 bg-clip-text text-transparent">
         BIG WISHES
        </span>
      </div>
    </div>

    <h1 class="text-3xl md:text-4xl font-bold text-gray-800 mb-8">
      <span class="bg-gradient-to-r from-indigo-600 to-blue-600 bg-clip-text text-transparent">
        Choose Your System
      </span>
    </h1>
    
    <div class="grid grid-cols-1 md:grid-cols-2 gap-8 max-w-2xl mx-auto">
      <!-- Admin Box -->
      <a href="<?php echo e(route('admin.dashboard')); ?>" class="group">
        <div class="bg-white/90 backdrop-blur-sm rounded-2xl shadow-xl p-8 transition-all duration-300 hover:shadow-2xl hover:-translate-y-2 border-2 border-transparent hover:border-indigo-500/30">
          <div class="w-20 h-20 bg-gradient-to-br from-indigo-100 to-blue-100 rounded-full flex items-center justify-center mx-auto mb-6 group-hover:from-indigo-200 group-hover:to-blue-200 transition-all">
            <svg xmlns="http://www.w3.org/2000/svg" class="h-10 w-10 text-indigo-600" fill="none" viewBox="0 0 24 24" stroke="currentColor">
              <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M16 7a4 4 0 11-8 0 4 4 0 018 0zM12 14a7 7 0 00-7 7h14a7 7 0 00-7-7z" />
            </svg>
          </div>
          <h2 class="text-2xl font-bold text-gray-800 mb-2">Admin</h2>
          <p class="text-gray-600">Management Dashboard</p>
          <div class="mt-4 text-sm text-indigo-600 opacity-0 group-hover:opacity-100 transition-opacity">
            Click to access →
          </div>
        </div>
      </a>

      <!-- POS Box -->
      <a href="<?php echo e(route('sales')); ?>" class="group">
        <div class="bg-white/90 backdrop-blur-sm rounded-2xl shadow-xl p-8 transition-all duration-300 hover:shadow-2xl hover:-translate-y-2 border-2 border-transparent hover:border-emerald-500/30">
          <div class="w-20 h-20 bg-gradient-to-br from-emerald-100 to-teal-100 rounded-full flex items-center justify-center mx-auto mb-6 group-hover:from-emerald-200 group-hover:to-teal-200 transition-all">
            <svg xmlns="http://www.w3.org/2000/svg" class="h-10 w-10 text-emerald-600" fill="none" viewBox="0 0 24 24" stroke="currentColor">
              <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M3 3h2l.4 2M7 13h10l4-8H5.4M7 13L5.4 5M7 13l-2.293 2.293c-.63.63-.184 1.707.707 1.707H17m0 0a2 2 0 100 4 2 2 0 000-4zm-8 2a2 2 0 11-4 0 2 2 0 014 0z" />
            </svg>
          </div>
          <h2 class="text-2xl font-bold text-gray-800 mb-2">POS</h2>
          <p class="text-gray-600">Point of Sale System</p>
          <div class="mt-4 text-sm text-emerald-600 opacity-0 group-hover:opacity-100 transition-opacity">
            Click to access →
          </div>
        </div>
      </a>
    </div>
  </div>
</body>
</html><?php /**PATH /home/craftada/iftikhar.appssoul.com/resources/views/system.blade.php ENDPATH**/ ?>