
<?php $__env->startSection('content'); ?>
    <div class="page-content">
        <div class="container-fluid">
            <div class="box-typical box-typical-padding">
                <form action="<?php echo e(route('report.quotations')); ?>" method="POST">
                    <div class="row">
                        <div class="col-sm-6">
                            <?php echo csrf_field(); ?>
                            <div class="row">
                                <div class="form-group col-md-4">
                                    <label><?php echo e(__('messages.start_date')); ?></label>
                                    <input type="text" class="form-control datepicker" name="sdate"
                                        value="<?php echo e($sdate); ?>">
                                </div>
                                <div class="form-group col-md-4 ">
                                    <label><?php echo e(__('messages.end_date')); ?></label>
                                    <input type="text" class="form-control datepicker" name="edate"
                                        value="<?php echo e($edate); ?>">
                                </div>
                                <div class="col-md-4">
                                    <button class="btn btn-purple mt-20" type="submit"> <?php echo e(__('messages.submit')); ?></button>
                                </div>
                            </div>
                        </div>
                    </div>
                </form>
            </div>
            <div class="box-typical box-typical-padding">
                <div class="row">
                    <div class="col-md-12">
                        <table class="table MyTable">
                            <thead>
                                <tr>
                                    <th> # </th>
                                    <th> <?php echo e(__('messages.date/time')); ?> </th>
                                    <th> <?php echo e(__('messages.invoice')); ?> </th>
                                    <th> <?php echo e(__('messages.customer')); ?> <?php echo e(__('messages.name')); ?> </th>
                                    <th> <?php echo e(__('messages.customer')); ?> <?php echo e(__('messages.contact')); ?> </th>
                                    <th> <?php echo e(__('messages.sub_total')); ?> </th>
                                    <th> <?php echo e(__('messages.discount')); ?> </th>
                                    <th> <?php echo e(__('messages.grand_total')); ?></th>
                                    <th> <?php echo e(__('messages.invoice')); ?> </th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php
                                    $sno = 0;
                                    $total_st = 0;
                                    $total_ds = 0;
                                    $total_gt = 0;
                                ?>
                                <?php $__currentLoopData = $quotations; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $qut): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <tr>
                                        <td><?php echo e($loop->iteration); ?></td>
                                        <td><?php echo e($qut->dated); ?></td>
                                        <td><a href="#" id="<?php echo e($qut->invoice); ?>" data-toggle="modal" data-target="#qinvoice-details"><?php echo e($qut->invoice); ?></a></td>
                                        <td><?php echo e($qut->customer->customer_name); ?></td>
                                        <td><?php echo e($qut->customer->customer_contact); ?></td>
                                        <td><?php echo e($qut->sub_total); ?></td>
                                        <td><?php echo e($qut->discount); ?></td>
                                        <td><?php echo e($qut->grand_total); ?></td>
                                        <td><a href="<?php echo e(route('quotations.invoice', $qut->invoice)); ?>" target="_blank"><i
                                                    class="fa fa-print"></i></a></td>
                                    </tr>
                                    <?php
                                        $total_st += $qut->sub_total;
                                        $total_ds += $qut->discount;
                                        $total_gt += $qut->grand_total;
                                    ?>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </tbody>
                            <tfoot>
                                <tr>
                                    <th>&nbsp;</th>
                                    <th>&nbsp;</th>
                                    <th>&nbsp;</th>
                                    <th>&nbsp;</th>
                                    <th>&nbsp;</th>
                                    <th class="text-purple"><?php echo e(formatAmount($total_st)); ?></th>
                                    <th class="text-warning"><?php echo e(formatAmount($total_ds)); ?></th>
                                    <th class="text-success"><?php echo e(formatAmount($total_gt)); ?></th>
                                </tr>
                            </tfoot>
                        </table>
                    </div>
                </div>
            </div><!--.container-fluid-->
            <div id="qinvoice-details" class="modal fade" role="dialog">
                <div class="modal-dialog modal-lg">
                    <!-- Modal content-->
                    <div class="modal-content">
                        <div class="modal-header">
                            <button type="button" class="modal-close" data-dismiss="modal">
                                <i class="font-icon-close-2"></i>
                            </button>
                            <h4 class="modal-title"><?php echo e(__('messages.invoice')); ?> : <span id="invoice_number"></span></h4>
                        </div>
                        <div class="modal-body" id="qinvoice-mbody">

                        </div>
                        <div class="modal-footer">
                            <button type="button" class="btn btn-default" data-dismiss="modal"><?php echo e(__('messages.close')); ?></button>
                        </div>
                    </div>
                </div>
            </div>
        </div><!--.page-content-->
    <?php $__env->stopSection(); ?>
    <?php $__env->startSection('customjs'); ?>
        <script src="<?php echo e(asset('custom_js/reports.js')); ?>"></script>
    <?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.template.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/craftada/iftikhar.appssoul.com/resources/views/admin/report_quotations.blade.php ENDPATH**/ ?>