@extends('admin.template.master')
@section('content')
    <div class="page-content">
        <div class="container-fluid">
            <header class="section-header pb-0">
                <div class="tbl">
                    <div class="tbl-row">
                        <div class="tbl-cell">
                            <h3 class="text-center text-capitalize">{{__('messages.stock')}} {{__('messages.transfers')}}</h3>
                        </div>
                    </div>
                </div>
            </header>
            <div class="box-typical box-typical-padding">
                <section class="tabs-section">
                    <div class="tabs-section-nav">
                        <div class="tbl">
                            <ul class="nav" role="tablist">
                                <li class="nav-item">
                                    <a class="nav-link active show" href="#tabs-2-tab-1" role="tab" data-toggle="tab"
                                        aria-selected="false">
                                        <span class="nav-link-in">
                                            {{__('messages.new_transfer')}}
                                        </span>
                                    </a>
                                </li>
                                <li class="nav-item">
                                    <a class="nav-link" href="#tabs-2-tab-2" role="tab" data-toggle="tab"
                                        aria-selected="false">
                                        <span class="nav-link-in">
                                            {{__('messages.view_all')}}
                                        </span>
                                    </a>
                                </li>
                            </ul>
                        </div>
                    </div><!--.tabs-section-nav-->

                    <div class="tab-content">
                        <div role="tabpanel" class="tab-pane fade active show" id="tabs-2-tab-1">
                            <div class="row">
                                <div class="col-md-1">
                                    <p><span class="label label-info"> {{__('messages.transfer')}} {{__('messages.to')}} : </span></p>
                                </div>
                                @foreach ($branches as $br)
                                    <div class="col-md-1">
                                        <input type="checkbox" class="trf_br_chk" value="{{ $br->branch_id }}">
                                        {{ $br->branch_name }}
                                    </div>
                                @endforeach

                                <div class="col-md-2">
                                    <p><span class="label label-danger"> {{__('messages.transfer')}} {{__('messages.from')}} : </span></p>
                                </div>
                                <div class="col-md-1 text-left">
                                    <select id="select_from">
                                        <option value="" selected> {{__('messages.choose')}} </option>
                                        @foreach ($branches as $br)
                                            <option value="{{ $br->branch_id }}">{{ $br->branch_name }}</option>
                                        @endforeach
                                    </select>
                                </div>
                                <div class="col-md-1">
                                    <select id="select_to">
                                        <option value="" selected> {{__('messages.choose')}} </option>
                                        <option value="0"> {{__('messages.admin')}} </option>

                                    </select>
                                </div>
                            </div>
                            <div class="row">
                                <div class="form-group col-md-3">
                                    <label>{{__('messages.name')}}/{{__('messages.barcode')}}</label>
                                    <input type="text" name="prd_stk" id="prd_stk" class="form-control"
                                        placeholder="" />
                                </div>
                                <div class="form-group col-md-3">
                                    <label>{{__('messages.quantity')}} <span id="prd_stk_unit"></span></label>
                                    <input type="text" name="prd_stk_qty" id="prd_stk_qty" class="form-control isnumber"
                                        placeholder="" />
                                </div>
                                <div class="form-group col-md-1">
                                    <label>&nbsp;</label>
                                    <button type="button" id="btn-add-prd-stk-atl" class="btn btn-block btn-primary"><i
                                            class="fa fa-plus"></i> </button>
                                </div>
                                <div class="form-group col-md-2">
                                    <label>&nbsp;</label>
                                    <button type="button" id="btn-process-items" class="btn btn-block btn-danger"><i
                                            class="fa fa-check"></i> {{__('messages.process')}}</button>
                                </div>
                                <div class="form-group col-md-2">
                                    <label>&nbsp;</label>
                                    <p id="req-msg" class="text-danger"></p>
                                </div>
                            </div>
                            <div class="row">
                                <div class="col-md-12">
                                    <table id="" class="table table-striped table-bordered dt-responsive nowrap sr"
                                        cellspacing="0" width="100%">
                                        <thead>
                                            <tr>
                                                <th>#</th>
                                                <th>{{__('messages.name')}}-{{__('messages.barcode')}}</th>
                                                <th>{{__('messages.quantity')}}</th>
                                                <th>{{__('messages.unit_price')}}</th>
                                                <th>{{__('messages.total_price')}}</th>
                                                <th>{{__('messages.remove')}}</th>
                                            </tr>
                                        </thead>
                                        <tbody id="prd_stk_tbody">

                                        </tbody>
                                        <tfoot>
                                            <tr>
                                                <th colspan="4">{{__('messages.total')}}</th>
                                                <th id="sub_total"></th>
                                                <th>&nbsp;</th>
                                            </tr>
                                        </tfoot>
                                    </table>
                                </div>
                            </div>

                        </div><!--.tab-pane-->
                        <div role="tabpanel" class="tab-pane fade" id="tabs-2-tab-2">
                            <div class="row">
                                <div class="col-md-12">
                                    <table id="transferTable"
                                        class="table table-striped table-bordered dt-responsive nowrap" style="width:100%;">
                                        <thead>
                                            <tr>
                                                <th>#</th>
                                                <th>{{__('messages.invoice')}} #</th>
                                                <th>{{__('messages.branch')}} {{__('messages.from')}}</th>
                                                <th>{{__('messages.branch')}} {{__('messages.to')}}</th>
                                                <th>{{__('messages.total_items')}}</th>
                                                <th>{{__('messages.date/time')}} </th>
                                                <th>{{__('messages.print')}}</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                        </div><!--.tab-pane-->
                    </div><!--.tab-content-->
                </section>
            </div>
        </div><!--.container-fluid-->
        <div id="trf-details" class="modal fade" role="dialog">
            <div class="modal-dialog modal-lg">
                <!-- Modal content-->
                <div class="modal-content">
                    <div class="modal-header">
                        <button type="button" class="modal-close" data-dismiss="modal">
                            <i class="font-icon-close-2"></i>
                        </button>
                        <h4 class="modal-title">{{__('messages.transfer')}} # : <span id="invoice_number"></span></h4>
                    </div>
                    <div class="modal-body" id="trf-mbody">

                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-default" data-dismiss="modal">{{__('messages.close')}}</button>
                    </div>
                </div>
            </div>
        </div>
    </div><!--.page-content-->
@endsection
@section('customjs')
    <script src="{{ asset('custom_js/transfer_scripts.js') }}"></script>
@endsection
