@extends('admin.template.master')
@section('content')
    <div class="page-content">
        <div class="container-fluid">
            <div class="box-typical box-typical-padding">
                <form action="{{ route('report.quotations') }}" method="POST">
                    <div class="row">
                        <div class="col-sm-6">
                            @csrf
                            <div class="row">
                                <div class="form-group col-md-4">
                                    <label>{{__('messages.start_date')}}</label>
                                    <input type="text" class="form-control datepicker" name="sdate"
                                        value="{{ $sdate }}">
                                </div>
                                <div class="form-group col-md-4 ">
                                    <label>{{__('messages.end_date')}}</label>
                                    <input type="text" class="form-control datepicker" name="edate"
                                        value="{{ $edate }}">
                                </div>
                                <div class="col-md-4">
                                    <button class="btn btn-purple mt-20" type="submit"> {{__('messages.submit')}}</button>
                                </div>
                            </div>
                        </div>
                    </div>
                </form>
            </div>
            <div class="box-typical box-typical-padding">
                <div class="row">
                    <div class="col-md-12">
                        <table class="table MyTable">
                            <thead>
                                <tr>
                                    <th> # </th>
                                    <th> {{__('messages.date/time')}} </th>
                                    <th> {{__('messages.invoice')}} </th>
                                    <th> {{__('messages.customer')}} {{__('messages.name')}} </th>
                                    <th> {{__('messages.customer')}} {{__('messages.contact')}} </th>
                                    <th> {{__('messages.sub_total')}} </th>
                                    <th> {{__('messages.discount')}} </th>
                                    <th> {{__('messages.grand_total')}}</th>
                                    <th> {{__('messages.invoice')}} </th>
                                </tr>
                            </thead>
                            <tbody>
                                @php
                                    $sno = 0;
                                    $total_st = 0;
                                    $total_ds = 0;
                                    $total_gt = 0;
                                @endphp
                                @foreach ($quotations as $qut)
                                    <tr>
                                        <td>{{ $loop->iteration }}</td>
                                        <td>{{ $qut->dated }}</td>
                                        <td><a href="#" id="{{ $qut->invoice }}" data-toggle="modal" data-target="#qinvoice-details">{{ $qut->invoice }}</a></td>
                                        <td>{{ $qut->customer->customer_name }}</td>
                                        <td>{{ $qut->customer->customer_contact }}</td>
                                        <td>{{ $qut->sub_total }}</td>
                                        <td>{{ $qut->discount }}</td>
                                        <td>{{ $qut->grand_total }}</td>
                                        <td><a href="{{ route('quotations.invoice', $qut->invoice) }}" target="_blank"><i
                                                    class="fa fa-print"></i></a></td>
                                    </tr>
                                    @php
                                        $total_st += $qut->sub_total;
                                        $total_ds += $qut->discount;
                                        $total_gt += $qut->grand_total;
                                    @endphp
                                @endforeach
                            </tbody>
                            <tfoot>
                                <tr>
                                    <th>&nbsp;</th>
                                    <th>&nbsp;</th>
                                    <th>&nbsp;</th>
                                    <th>&nbsp;</th>
                                    <th>&nbsp;</th>
                                    <th class="text-purple">{{formatAmount($total_st)}}</th>
                                    <th class="text-warning">{{formatAmount($total_ds)}}</th>
                                    <th class="text-success">{{formatAmount($total_gt)}}</th>
                                </tr>
                            </tfoot>
                        </table>
                    </div>
                </div>
            </div><!--.container-fluid-->
            <div id="qinvoice-details" class="modal fade" role="dialog">
                <div class="modal-dialog modal-lg">
                    <!-- Modal content-->
                    <div class="modal-content">
                        <div class="modal-header">
                            <button type="button" class="modal-close" data-dismiss="modal">
                                <i class="font-icon-close-2"></i>
                            </button>
                            <h4 class="modal-title">{{__('messages.invoice')}} : <span id="invoice_number"></span></h4>
                        </div>
                        <div class="modal-body" id="qinvoice-mbody">

                        </div>
                        <div class="modal-footer">
                            <button type="button" class="btn btn-default" data-dismiss="modal">{{__('messages.close')}}</button>
                        </div>
                    </div>
                </div>
            </div>
        </div><!--.page-content-->
    @endsection
    @section('customjs')
        <script src="{{ asset('custom_js/reports.js') }}"></script>
    @endsection
