@extends('admin.template.master')
@section('content')
    <div class="page-content">
        <div class="container-fluid">
            <div class="box-typical box-typical-padding">
                <h3 class="page-header text-center text-capitalize">{{__('messages.'.pageTitle())}}</h3>
                
                <div class="row">
                    <div class="col-md-3">
                        <section class="widget widget-simple-sm">
                            <div class="widget-simple-sm-statistic">
                                <div class="number">{{formatAmount($sales['total'])}}</div>
                                <div class="caption color-blue">{{__('messages.ts')}}</div>
                            </div>
                        </section><!--.widget-simple-sm-->
                    </div>
                    <div class="col-md-3">
                        <section class="widget widget-simple-sm">
                            <div class="widget-simple-sm-statistic">
                                <div class="number">{{formatAmount($purchases['total'])}}</div>
                                <div class="caption color-blue">{{__('messages.tp')}}</div>
                            </div>
                        </section><!--.widget-simple-sm-->
                    </div>
                    <div class="col-md-3">
                        <section class="widget widget-simple-sm">
                            <div class="widget-simple-sm-statistic">
                                <div class="number">{{formatAmount($expenses['total'])}}</div>
                                <div class="caption color-blue">{{__('messages.te')}}</div>
                            </div>
                        </section><!--.widget-simple-sm-->
                    </div>
                    <div class="col-md-3">
                        <section class="widget widget-simple-sm">
                            <div class="widget-simple-sm-statistic">
                                <div class="number">{{ formatAmount($sales['total']-($purchases['total']+$expenses['total'])) }}</div>
                                <div class="caption color-blue">{{__('messages.tpl')}}</div>
                            </div>
                        </section><!--.widget-simple-sm-->
                    </div>
                </div>
                <div class="row">
                    <div class="col-md-3">
                        <section class="widget widget-simple-sm">
                            <div class="widget-simple-sm-statistic">
                                <div class="number">{{formatAmount($sales['monthly'])}}</div>
                                <div class="caption color-blue">{{__('messages.ms')}}</div>
                            </div>
                        </section><!--.widget-simple-sm-->
                    </div>
                    <div class="col-md-3">
                        <section class="widget widget-simple-sm">
                            <div class="widget-simple-sm-statistic">
                                <div class="number">{{formatAmount($purchases['monthly'])}}</div>
                                <div class="caption color-blue">{{__('messages.mp')}}</div>
                            </div>
                        </section><!--.widget-simple-sm-->
                    </div>
                    <div class="col-md-3">
                        <section class="widget widget-simple-sm">
                            <div class="widget-simple-sm-statistic">
                                <div class="number">{{formatAmount($expenses['monthly'])}}</div>
                                <div class="caption color-blue">{{__('messages.me')}}</div>
                            </div>
                        </section><!--.widget-simple-sm-->
                    </div>
                    <div class="col-md-3">
                        <section class="widget widget-simple-sm">
                            <div class="widget-simple-sm-statistic">
                                <div class="number">{{ formatAmount($sales['monthly']-($purchases['monthly']+$expenses['monthly'])) }}</div>
                                <div class="caption color-blue">{{__('messages.mpl')}}</div>
                            </div>
                        </section><!--.widget-simple-sm-->
                    </div>
                </div>
                <div class="row">
                    <div class="col-md-3">
                        <section class="widget widget-simple-sm">
                            <div class="widget-simple-sm-statistic">
                                <div class="number">{{formatAmount($sales['daily'])}}</div>
                                <div class="caption color-blue">{{__('messages.ds')}}</div>
                            </div>
                        </section><!--.widget-simple-sm-->
                    </div>
                    <div class="col-md-3">
                        <section class="widget widget-simple-sm">
                            <div class="widget-simple-sm-statistic">
                                <div class="number">{{formatAmount($purchases['daily'])}}</div>
                                <div class="caption color-blue">{{__('messages.dp')}}</div>
                            </div>
                        </section><!--.widget-simple-sm-->
                    </div>
                    <div class="col-md-3">
                        <section class="widget widget-simple-sm">
                            <div class="widget-simple-sm-statistic">
                                <div class="number">{{formatAmount($expenses['daily'])}}</div>
                                <div class="caption color-blue">{{__('messages.de')}}</div>
                            </div>
                        </section><!--.widget-simple-sm-->
                    </div>
                    <div class="col-md-3">
                        <section class="widget widget-simple-sm">
                            <div class="widget-simple-sm-statistic">
                                <div class="number">{{ formatAmount($sales['daily']-($purchases['daily']+$expenses['daily'])) }}</div>
                                <div class="caption color-blue">{{__('messages.dpl')}}</div>
                            </div>
                        </section><!--.widget-simple-sm-->
                    </div>
                </div>
                
                <div class="row">
                    <div class="col-md-12">
                        <table class="table table-bordered table-striped">
                            <thead>
                                <tr>
                                    <th>#</th>
                                    <th>{{__('messages.date/time')}}</th>
                                    <th>{{__('messages.branch')}}</th>
                                    <th>{{__('messages.invoice')}}</th>
                                    <th>{{__('messages.payment_type')}}</th>
                                    <th>{{__('messages.sub_total')}}</th>
                                    <th>{{__('messages.discount')}}</th>
                                    <th>{{__('messages.grand_total')}}</th>
                                    <th>{{__('messages.print')}}</th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach($lastTenSales as $sale)
                                    <tr>
                                        <td>{{ $loop->iteration }}</td>
                                        <td>{{ $sale->dated }}</td>
                                        <td>{{ $sale->branch->branch_name }}</td>
                                        <td>{{ $sale->invoice }}</td>
                                        <td>{{ $sale->payment_type }}</td>
                                        <td>{{ formatAmount($sale->sub_total) }}</td>
                                        <td>{{ formatAmount($sale->discount) }}</td>
                                        <td>{{ formatAmount($sale->grand_total) }}</td>
                                        <td><a href="{{route('sales.invoice',['id'=>$sale->invoice])}}" target="_blank" class="text-primary"><i class="fa fa-print"></i></a></td>
                                    </tr>
                                @endforeach
                            </tbody>

                        </table>
                    </div>
                </div>
            </div>
        </div><!--.container-fluid-->
    </div><!--.page-content-->
@endsection
@section('customjs')
@endsection
