$(document).ready(function(){
	$('.ifnotify2').trigger('click');
	// Datepicker 
	$('.datepicker').datepicker({dateFormat:'yy-mm-dd'});
	$('#customersTable').DataTable({
    	 "sAjaxSource": base_url+'customers/show_customers',
    	 "pageLength": 10,
    	 "order": [],
    	 "responsive":true
    });


    $('#btn-add-customer').on('click',function(e){
        $('#cus-msg').fadeOut('slow');
        $('#cus-msg').removeClass();
        var cus_name = $('#cus_name').val();
        var cus_contact = $('#cus_contact').val();
        var cus_email = $('#cus_email').val();
        var cus_address = $('#cus_address').val();
        var cus_notes = $('#cus_notes').val();
        if(cus_name=="")
        {
            $('#cus-msg').html('Please provide Name').addClass('text-warning').fadeIn('slow');
            return false;
        }
        if(cus_contact=="")
        {
            $('#cus-msg').html('Please provide Contact').addClass('text-warning').fadeIn('slow');
            return false;
        }
        // if(cus_email=="")
        // {
        //     $('#cus-msg').html('Please provide Email').addClass('text-warning').fadeIn('slow');
        //     return false;
        // }
        // if(cus_address=="")
        // {
        //     cus_address='N/A';
        // }
        // if(cus_notes=="")
        // {
        //     cus_notes = 'N/A';
        // }
        
        $.ajax({
            url:base_url+'customers/add_customers',
            type:'POST',
            data:{cus_name:cus_name,cus_contact:cus_contact,cus_email:cus_email,cus_address:cus_address, cus_notes:cus_notes},
            success:function(response)
            {
                if(response==1)
                {
                    $('#ifnotify-success').text(' Added');
                    $('#ifnotify-success').trigger('click');
                    $('#cus_name').val("");
                    $('#cus_contact').val("");
                    $('#cus_email').val("");
                    $('#cus_address').val("");
                    $('#cus_notes').val("");
                }
                else if(response==2)
                {
                    $('#ifnotify-warning').text(' Contact already exists');
                    $('#ifnotify-warning').trigger('click');
                }
                else if(response==0)
                {
                    $('#ifnotify-error').text(' Error try again');
                    $('#ifnotify-error').trigger('click');
                }
                else
                {   
                    $('#ifnotify-warning').text(response);
                    $('#ifnotify-warning').trigger('click');
                }
                $('#customersTable').DataTable().ajax.reload();
            }
        });
    });

    $('#customer-edit-modal').on('show.bs.modal',function(e){
        var cus_id = e.relatedTarget.id;
        $('#e_cus-msg').html("");
        $('#e_cus_id').val(cus_id);
        $.ajax({
            url:base_url+'customers/get_customers',
            type:'POST',
            data:{cus_id:cus_id},
            success:function(msg)
            {
                var res = $.parseJSON(msg);
                $('#e_cus_name').val(res[0]);   
                $('#e_cus_contact').val(res[1]);
                $('#e_cus_email').val(res[2]);
                $('#e_cus_address').val(res[3]);
                $('#e_cus_notes').val(res[4]);
            }
        });
    });

    $('#btn-update-customer').on('click',function(e){   
        $('#e_cus-msg').fadeOut('slow');
        $('#e_cus-msg').removeClass();
        var cus_id = $('#e_cus_id').val();
        var cus_name = $('#e_cus_name').val();
        var cus_contact = $('#e_cus_contact').val();
        var cus_email = $('#e_cus_email').val();
        var cus_address = $('#e_cus_address').val();
        var cus_notes = $('#e_cus_notes').val();
        if(cus_name=="")
        {
            $('#e_cus-msg').html('Please provide Name').addClass('text-warning').fadeIn('slow');
            return false;
        }
        if(cus_contact=="")
        {
            $('#e_cus-msg').html('Please provide Contact').addClass('text-warning').fadeIn('slow');
            return false;
        }
        if(cus_email=="")
        {
            $('#e_cus-msg').html('Please provide Email').addClass('text-warning').fadeIn('slow');
            return false;
        }
        if(cus_address=="")
        {
            cus_address='N/A';
        }
        if(cus_notes=="")
        {
            cus_notes = 'N/A';
        }
        $.ajax({
            url:base_url+'customers/update_customers',
            type:'POST',
            data:{cus_id:cus_id,cus_name:cus_name,cus_email:cus_email,cus_contact:cus_contact,cus_address:cus_address,cus_notes:cus_notes},
            success:function(response)
            {
                if(response==1)
                {

                    $('#ifnotify-success').text(' Updated');
                    $('#ifnotify-success').trigger('click');
                }
                else if(response==2)
                {
                    $('#ifnotify-warning').text('Nothing to update');
                    $('#ifnotify-warning').trigger('click');
                }
                else if(response==3)
                {
                    $('#ifnotify-warning').text(' Contact already exists');
                    $('#ifnotify-warning').trigger('click');
                }
                else if(response==0)
                {
                    $('#ifnotify-error').text(' Error try again');
                    $('#ifnotify-error').trigger('click');
                }
                else
                {
                    $('#ifnotify-warning').text(response);
                    $('#ifnotify-warning').trigger('click');
                }
                $('#customersTable').DataTable().ajax.reload();
            }
        });
    });

    $('#customersTable').on('click','.ifdel',function(e){
        e.preventDefault();
        var href = $(this).attr('href');
        if(typeof(href) != "undefined" && href !== null)
        {
          swal({
              title:"Are you sure?",
              text: "You will not be able to recover this data!",
              type: "warning",
              showCancelButton: true,
              confirmButtonClass: 'btn-danger btn-md waves-effect waves-light',
              confirmButtonColor: "#DD6B55",
              confirmButtonText: "Yes, delete it!",
              cancelButtonText: "No, cancel it!",
              closeOnConfirm: true,
              closeOnCancel: true
          }, function (isConfirm) {
              if (isConfirm) 
              {
                window.location=href;
              } 
              else 
              {
                  return false;
              }
          });
        }
    });

        

    $('#customer-invoices-modal').on('show.bs.modal',function(e){
    	var customer_id = e.relatedTarget.id;
    	$.ajax({
    		url:base_url+'customers/get_customer_invoices',
    		type:'POST',
    		data:{customer_id:customer_id},
    		success:function(msg)
    		{
    			var res = $.parseJSON(msg);
    			$('#pinv-mbody').html("");
    			$('#pinv-mbody').html(res[0]);
    		}
    	});
    });

    $('#make-payment-modal').on('show.bs.modal',function(e){
    	var invoice = e.relatedTarget.id;
    	var amount  = parseFloat(e.relatedTarget.getAttribute('href'));
    	var advance = parseFloat(e.relatedTarget.getAttribute('title'));
        if(isNaN(advance)){advance=0;}
    	$('#invoice_number').html("");
    	$('#invoice_number').html(invoice);
    	$('#payment-tbody').html("");
    	$('#payment-tbody').html('<tr><td></td><td></td><td class="pamount">'+amount+'</td></tr>');
    	if(advance>0)
    	{
    		$('#payment-tbody').append('<tr><td></td><td class="adv">'+advance+'</td><td class="pamount">'+(amount-advance)+'</td></tr>')	
    	}
    	amount = (amount-advance);
    	recalcId();
    	$.ajax({
    		url:base_url+'customers/get_customer_payments',
    		type:'POST',
    		data:{invoice:invoice,amount:amount,advance:advance},
    		success:function(msg)
    		{
    			var res = $.parseJSON(msg);
    			$('#payment-tbody').append(res[0]);
    			recalcId();
    		}	
    	});
    });

    $('#ptext').on('keyup',function(e){
    	var amount  = parseFloat($('.pamount:last').text());
    	var pamount = parseFloat($(this).val());
    	if(pamount>amount)
    	{
    		$('#ifnotify-warning').text(' Amount must be less or equal last payment');
    		$('#ifnotify-warning').trigger('click');
    		return false;
    	}
    });

    $('#ptype').on('change',function(e){
        if($(this).val()=='bank')
        {
            $('#pbankdiv').removeClass('hidden');
            $('#pchqdiv').addClass('hidden');
        }
        else if($(this).val()=='cheque')
        {
            $('#pbankdiv').addClass('hidden');
            $('#pchqdiv').removeClass('hidden');
        }
        else
        {
            $('#pbankdiv').addClass('hidden');
            $('#pchqdiv').addClass('hidden');
        }
    });

    // $("#btn-make-payment").on('click',function(e){
    // 	var famount  = parseFloat($('.pamount:first').text());
    // 	var amount  = parseFloat($('.pamount:last').text());
    // 	var pamount = parseFloat($('#ptext').val());
    // 	var advance = parseFloat($('.adv').text());
    // 	if(isNaN(pamount)){pamount=0;}
    // 	if(pamount==0)
    // 	{
    // 		$('#ifnotify-warning').text(' Please enter amount to pay');
    // 		$('#ifnotify-warning').trigger('click');
    // 		return false;
    // 	}
    // 	if(pamount>amount)
    // 	{
    // 		$('#ifnotify-warning').text(' Amount must be less or equal last payment');
    // 		$('#ifnotify-warning').trigger('click');
    // 		return false;
    // 	}
    // 	var invoice = $('#invoice_number').text();
    // 	$.ajax({
    // 		url:base_url+'customers/make_customer_payments',
    // 		type:'POST',
    //         async:false,
    // 		data:{invoice:invoice,pamount:pamount},
    // 		success:function(msg)
    // 		{
    // 			$('#ptext').val('');
    // 			var res = $.parseJSON(msg);
    // 			if(res[0]!=0)
    // 			{
    // 				$.ajax({
    // 					url:base_url+'customers/get_customer_payments',
    // 					type:'POST',
    //                     async:false,
    // 					data:{invoice:invoice,amount:famount,sadv:'yes'},
    // 					success:function(msg)
    // 					{
    // 						var res = $.parseJSON(msg);
    // 						$('#payment-tbody').html("");
    // 						$('#payment-tbody').html('<tr><td></td><td></td><td class="pamount">'+famount+'</td></tr>');
    // 						if(!isNaN(advance))
    // 						{
    // 							$('#payment-tbody').append('<tr><td></td><td class="adv">'+advance+'</td><td class="pamount">'+(famount-advance)+'</td></tr>');
    // 						}
    // 						$('#payment-tbody').append(res[0]);
    //                         // window.open(base_url+'customers/receipt/'+invoice);
    // 						recalcId();
    // 					}	
    // 				});
    // 			}
    // 		}
    // 	});
    // });

    $("#btn-make-payment").on('click',function(e){
        var famount = parseFloat($('.pamount:first').text());
        var amount  = parseFloat($('.pamount:last').text());
        var pamount = parseFloat($('#ptext').val());
        var advance = parseFloat($('.adv').text());
        var pdate   = $('#pdate').val();
        var ptype   = $('#ptype').val();
        var pbank   = $('#pbank').val();
        var pcheq   = $('#pcheq').val();
        var pdesc   = $('#pdesc').val();
        if(isNaN(pamount)){pamount=0;}
        if(pamount==0)
        {
            $('#ifnotify-warning').text(' Please enter amount to pay');
            $('#ifnotify-warning').trigger('click');
            return false;
        }
        if(pamount>amount)
        {
            $('#ifnotify-warning').text(' Amount must be less or equal last payment');
            $('#ifnotify-warning').trigger('click');
            return false;
        }
        if(pdate=="")
        {
            $('#ifnotify-warning').text(' Please enter payment date');
            $('#ifnotify-warning').trigger('click');
            return false;
        }
        if(ptype=='bank' && pbank=="")
        {
            $('#ifnotify-warning').text(' Please select Bank');
            $('#ifnotify-warning').trigger('click');
            return false;   
        }
        if(ptype=='cheque' && pcheq=="")
        {
            $('#ifnotify-warning').text(' Please Enter Cheque Number');
            $('#ifnotify-warning').trigger('click');
            return false;   
        }
        if(pdesc=="")
        {
            $('#ifnotify-warning').text(' Please enter Description');
            $('#ifnotify-warning').trigger('click');
            return false;
        }
        var invoice = $('#invoice_number').text();
        $.ajax({
            url:base_url+'customers/make_customer_payments',
            type:'POST',
            async:false,
            data:{invoice:invoice,pamount:pamount,pdate:pdate,ptype:ptype,pbank:pbank,pcheq:pcheq,pdesc:pdesc},
            success:function(msg)
            {
                $('#ptext').val('');
                $('#pdate').val('');
                var res = $.parseJSON(msg);
                if(res[0]!=0)
                {
                    $.ajax({
                        url:base_url+'customers/get_customer_payments',
                        type:'POST',
                        async:false,
                        data:{invoice:invoice,amount:famount,sadv:'yes'},
                        success:function(msg)
                        {
                            var res = $.parseJSON(msg);
                            $('#payment-tbody').html("");
                            $('#payment-tbody').html('<tr><td></td><td></td><td class="pamount">'+famount+'</td></tr>');
                            if(!isNaN(advance))
                            {
                                $('#payment-tbody').append('<tr><td></td><td class="adv">'+advance+'</td><td class="pamount">'+(amount-advance)+'</td><td></td><td><a href="'+base_url+'customers/receipt_print/'+invoice+'/yes" target="_blank"><i class="fa fa-print"></i></a></td><td></td></tr>');   
                            }
                            $('#payment-tbody').append(res[0]);
                            window.open(base_url+'customers/receipt/'+invoice);
                            recalcId();
                        }   
                    });
                }
            }
        });
    });

    $(document).on('click','.rmv-payment',function(e){
        e.preventDefault();
        var famount = parseFloat($('.pamount:first').text());
        var invoice = $('#invoice_number').text();
        var advance = parseFloat($('.adv').text());
        var pay_id  = $(this).attr('id');
        $.ajax({
            url:base_url+'customers/remove_payments',
            type:'POST',
            async:false,
            data:{pay_id:pay_id},
            success:function(msg)
            {
                var res = $.parseJSON(msg);
                if(res[0]!=0)
                {
                    $.ajax({
                        url:base_url+'customers/get_customer_payments',
                        type:'POST',
                        async:false,
                        data:{invoice:invoice,amount:famount,sadv:'yes'},
                        success:function(msg)
                        {
                            var res = $.parseJSON(msg);
                            $('#payment-tbody').html("");
                            $('#payment-tbody').html('<tr><td></td><td></td><td class="pamount">'+famount+'</td></tr>');
                            if(!isNaN(advance))
                            {
                                $('#payment-tbody').append('<tr><td></td><td class="adv">'+advance+'</td><td class="pamount">'+(famount-advance)+'</td></tr>');
                            }
                            $('#payment-tbody').append(res[0]);
                            // window.open(base_url+'customers/receipt/'+invoice);
                            recalcId();
                        }   
                    });
                }
            }
        });
    });

    $('#customer-invoice-details-modal').on('show.bs.modal',function(e){
        var invoice = e.relatedTarget.id;
        $.ajax({
            url:base_url+'customers/get_invoice_details',
            type:'POST',
            data:{invoice:invoice},
            success:function(msg)
            {
                var res = $.parseJSON(msg);
                $('#invoice-details-mbody').html("");
                $('#invoice-details-mbody').html(res[0]);
            }
        });
    });

    $('#sinvoice-details').on('show.bs.modal',function(e){
        var invoice = e.relatedTarget.id;
        $('#invoice_number').text(invoice);
        var token_name   = "<?php echo $this->security->get_csrf_token_name();?>";
        var token_value  = $('#my_csrf').val();
        var form_data = new FormData();
        form_data.append('invoice',invoice);
        form_data.append(token_name,token_value);
        $.ajax({
            url:base_url+'reports/sales_invoice_details',
            type:'POST',
            processData:false,
            contentType: false,
            data:form_data,
            success:function(response)
            {
                var res = $.parseJSON(response)
                $('#my_csrf').val(res[0]);
                $('#sinvoice-mbody').html('');
                $('#sinvoice-mbody').html(res[1]);
            }
        });
    });
});// End Ready Function
