<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class StockIn extends Model
{
    protected $table = 'stock_in';
    public $timestamps = false;
    protected $fillable = [
        'stk_item',
        'stk_quantity',
        'stk_date',
        'stk_price',
        'stk_total',
        'stk_notes',
        'stk_status',
        'dated',
        'in_user',
    ];

    public function item()
    {
        return $this->belongsTo(StockItems::class, 'stk_item', 'stk_barcode');
        //                                          ^foreign key     ^owner key
    }

}
