<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Sales extends Model
{
    protected $table = 'sales';
    public $timestamps = false;
    protected $fillable = [
        'branch_id',
        'invoice',
        'type',
        'customer_id',
        'purchases',
        'sub_total',
        'payment_type',
        'cheque_number',
        'discount',
        'grand_total',
        'advance',
        'payments',
        'notes',
        'points_discount',
        'dated',
    ];

    public function branch()
    {
        return $this->belongsTo(Branches::class,'branch_id','branch_id');
    }
    public function salesDetails()
    {
        return $this->hasMany(SalesDetails::class, 'invoice', 'invoice');
        //                         ^model          ^foreign key ^local key
    }
}
