<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Branches extends Model
{
    protected $table = 'branches';
    public $timestamps = false;
    protected $fillable =[
        'branch_name',
        'logo',
        'status',
        'dated'
    ];
    public function sales()
    {
        return $this->hasMany(Sales::class,'branch_id','branch_id');
    }
    public function transfersSent()
    {
        return $this->hasMany(Transfers::class, 'branch_id_from', 'branch_id');
    }
    public function transfersReceived()
    {
        return $this->hasMany(Transfers::class, 'branch_id', 'branch_id');
    }
    public function transfers()
    {
        return $this->hasMany(Transfers::class, 'branch_id', 'branch_id');
    }
    public function expenses()
    {
        return $this->hasMany(Expenses::class, 'branch_id', 'branch_id');
    }
    public function stock1()
    {
        return $this->hasMany(Stock1::class, 'branch_id', 'branch_id');
    }
    public function stock2()
    {
        return $this->hasMany(Stock2::class, 'branch_id', 'branch_id');
    }
    public function stock3()
    {
        return $this->hasMany(Stock3::class, 'branch_id', 'branch_id');
    }


}
