<?php

namespace App\Http\Controllers;

use App\Models\Branches;
use App\Models\ExpenseCategory;
use App\Models\Expenses;
use App\Models\PurchaseDetails;
use App\Models\Purchases;
use App\Models\QuotationDetails;
use App\Models\Quotations;
use App\Models\ReturnItems;
use App\Models\Sales;
use App\Models\SalesDetails;
use App\Models\StockCategoryItems;
use App\Models\StockIn;
use App\Models\StockItems;
use App\Models\StockOut;
use App\Models\StockRemoved;
use App\Models\TransferDetails;
use App\Models\Transfers;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Schema;

class ReportController extends Controller
{
    public function sales(Request $request)
    {
        $branch_ids = '';
        if ($request->sdate && $request->edate) {
            $sdate = $request->sdate;
            $edate = $request->edate;
        } else {
            $today = date('Y-m-d');
            $sdate = $today;
            $edate = $today;
        }
        $query = Sales::with('branch');
        if ($request->brnchk) {
            $branch_ids = $request->brnchk;
            $query->whereIn('branch_id', $branch_ids);
        }
        $query->whereDate('dated', '>=', $sdate);
        $query->whereDate('dated', '<=', $edate);
        $data['sales'] = $query->get();
        $data['branch_ids'] = $branch_ids;
        $data['sdate'] = $sdate;
        $data['edate'] = $edate;
        $data['branches'] = Branches::all();
        return view('admin.report_sales', $data);
    }

    public function sales_details(Request $request)
    {
        $invoice     = $request->invoice;
        $q = SalesDetails::where('invoice', $invoice)->get();
        $table = 'NO ITEMS FOR THIS SALES';
        if ($q->count() > 0) {
            $sno = 0;
            $total_sprice = 0;
            $total_pprice = 0;
            $table = '<h3 class="text-center"> ITEMS </h3>';
            $table .= '<table class="table">
	    				<thead>
	    					<tr>
	    						<th>Sno</th>
	    						<th>Item</th>
	    						<th>Price</th>
	    						<th>Qty</th>
	    						<th>Total</th>
	    						<th>Purchase</th>
	    						<th>Difference</th>
	    					</tr>
	    				</thead>
	    				<tbody>';
            foreach ($q as $r) {
                $sno++;
                $table .= '<tr>
	    					<td>' . $sno . '</td>
	    					<td>' . $r->item_name . '</td>
	    					<td>' . $r->item_price . '</td>
	    					<td>' . $r->item_qty . '</td>
	    					<td>' . $r->item_total . '</td>
	    					<td>' . $r->item_pprice . '</td>
	    					<td>' . ($r->item_total - $r->item_pprice) . '</td>
	    				  </tr>';
                $total_sprice += $r->item_total;
                $total_pprice += $r->item_pprice;
            }
            $table .= '</tbody>
		    				  <tfoot>
		    				  	<tr>
		    				  		<td>&nbsp;</td>
		    				  		<td>&nbsp;</td>
		    				  		<td>&nbsp;</td>
		    				  		<td>&nbsp;</td>
		    				  		<th>' . $total_sprice . '</th>
		    				  		<th>' . $total_pprice . '</th>
		    				  		<th>' . ($total_sprice - $total_pprice) . '</th>
		    				  	</tr>
		    				  </tfoot>
	    				  </table>';
        }
        echo json_encode(array($table));
    }

    public function sales_category_report(Request $request)
    {
        $branch_ids = '';
        if ($request->sdate && $request->edate) {
            $sdate = $request->sdate;
            $edate = $request->edate;
        } else {
            $today = date('Y-m-d');
            $sdate = $today;
            $edate = $today;
        }
        if ($request->brnchk) {
            $branch_ids = $request->brnchk;
        }

        $data['sdate'] = $sdate;
        $data['edate'] = $edate;


        $query = StockCategoryItems::all();
        $data['sales_category'] = $query;
        $data['branch_ids'] = $branch_ids;
        return view('admin.report_sales_category', $data);
    }

    public function sales_items_report(Request $request)
    {
        $branch_ids = '';
        if ($request->sdate && $request->edate) {
            $sdate = $request->sdate;
            $edate = $request->edate;
        } else {
            $today = date('Y-m-d');
            $sdate = $today;
            $edate = $today;
        }

        if ($request->brnchk) {
            $branch_ids = $request->brnchk;
        }
        $data['sdate'] = $sdate;
        $data['edate'] = $edate;
        // $query = $this->db->get('stock_category_items');
        // $data['sales_category'] = $query->result();
        $data['branch_ids'] = $branch_ids;
        return view('report_sales_items', $data);
    }

    public function sales_items_by_branch($branch_id, Request $request)
    {
        if ($request->sdate && $request->edate) {
            $sdate = $request->sdate;
            $edate = $request->edate;
        } else {
            $today = date('Y-m-d');
            $sdate = $today;
            $edate = $today;
        }
        $data['sdate'] = $sdate;
        $data['edate'] = $edate;
        $data['branch_id'] = $branch_id;
        $query = SalesDetails::with(['item' . $branch_id, 'item' . $branch_id . '.category'])->whereDate('dated', '>=', $sdate)
            ->whereDate('dated', '<=', $edate)
            ->where('branch_id', $branch_id)
            ->groupBy('item_barcode')
            ->selectRaw('item_barcode, SUM(item_qty) as item_qty')
            ->get();
        $data['query'] = $query;
        return view('admin.report_sales_items_by_branch', $data);
    }

    public function stock_available(Request $request)
    {
        $branches = null;
        $query = Branches::all();
        $data['branch_ids'] = $query;
        if ($query->count() > 0) {
            foreach ($query as $rows) {
                $tableName = 'stock_' . $rows->branch_id;
                if (!Schema::hasTable($tableName)) {
                    DB::statement("CREATE TABLE $tableName LIKE stock_items");
                }
                $branches .= '<th>' . $rows->branch_name . '</th>';
            }
        }
        $stock_available = StockItems::with('category')->get();
        $finalData = [];

        foreach ($stock_available as $item) {
            $row = [
                'stk_category_name' => $item->category->category_name??null,
                'stk_barcode'       => $item->stk_barcode,
                'stk_name'          => $item->stk_name,
                'stk_qty'           => $item->stk_qty,
                'stk_pprice'        => $item->stk_pprice,
                'stk_sprice_b1'     => $item->stk_sprice_b1,
                'branches_qty'      => [],
                'margin_percent'    => $item->stk_pprice != 0
                    ? number_format(abs((($item->stk_pprice - $item->stk_sprice_b1) / $item->stk_pprice) * 100), 2)
                    : 0,
            ];

            foreach ($query as $branch) {
                $tableName = 'stock_' . $branch->branch_id;
                $record = DB::table($tableName)->where('stk_barcode', $item->stk_barcode)->first();
                if ($record) {
                    $row['branches_qty'][$branch->branch_id] =$record->stk_qty;
                } else {
                    $row['branches_qty'][$branch->branch_id] = 0;
                }
            }

            $finalData[] = $row;
        }

        // return $finalData;
        $data['stock_data'] = $finalData;
        $data['branch_ids'] = $query;
        
        // $data['branches'] = $branches;
        return view('admin.report_stock_available', $data);
    }

    public function stock_zero(Request $request)
    {	
    	$branches = null;
    	$query = Branches::whereIn('branch_id', [1, 2])->get();
    	$data['branch_ids'] = $query;
    	if($query->count()>0)
    	{
    		foreach($query as $rows)
    		{
    			$tableName = 'stock_'.$rows->branch_id;
                if (!Schema::hasTable($tableName)) {
                    DB::statement("CREATE TABLE $tableName LIKE stock_items");
                }
    			$branches .= '<th>'.$rows->branch_name.'</th>';
    		}
    	}

    	$data['branches'] = $branches;

    	$stock_zero=StockItems::with('category')->get();
        $finalData = [];

        foreach($stock_zero as $item){
             
             $row = [
                'stk_category_name' => $item->category->category_name??null,
                'stk_barcode'       => $item->stk_barcode,
                'stk_name'          => $item->stk_name,
                'branches_qty'      => [],
                'branches_txt'      => null
            ];
            foreach($query as $branch) {
                $tableName = 'stock_' . $branch->branch_id;
                $record = DB::table($tableName)->where('stk_barcode', $item->stk_barcode)->first();
                if ($record) {
                    if($record->stk_qty == 0) {
                        $row['branches_qty'][$branch->branch_id] = $record->stk_qty;
                        $row['branches_txt'] .= 'Branch-'.$branch->branch_id.'<br>';
                    } else {
                        $row['branches_qty'][$branch->branch_id] = '-';
                    }
                } else {
                   $row['branches_txt'] .= 'Branch-'.$branch->branch_id.'<br>';
                }
            }
            $finalData[] = $row;
        }
        $data['stock_data'] = $finalData;
    	return view('admin.report_stock_zero',$data);
    }

    public function purchases(Request $request)
	{	
		if($request->sdate && $request->edate)
		{
			$sdate = $request->sdate;
			$edate = $request->edate;
		}
		else
		{
			$today = date('Y-m-d');
			$sdate = $today;
			$edate = $today;	
		}
        $query = Purchases::whereDate('dated', '>=', $sdate)
			->whereDate('dated', '<=', $edate)
			->get();
		$data['purchases'] = $query;
		$data['sdate']=$sdate;
		$data['edate']=$edate;

		return view('admin.report_purchases',$data);
	}

    public function purchase_details(Request $request)
	{
 		$invoice     = $request->invoice;
	    $q=PurchaseDetails::where('invoice', $invoice)->get();
	    if($q->count()>0)
	    {
	    	$sno=0;
	    	$total_sprice =0;
	    	$total_pprice =0;
	    	$table = '<table class="table">
	    				<thead>
	    					<tr>
	    						<th>Sno</th>
	    						<th>Item</th>
	    						<th>Price</th>
	    						<th>Qty</th>
	    						<th>Total</th>
	    					</tr>
	    				</thead>
	    				<tbody>';
	    	foreach($q as $r)
	    	{
	    		$sno++;
	    		$table .='<tr>
	    					<td>'.$sno.'</td>
	    					<td>'.$r->item_name.'</td>
	    					<td>'.$r->item_price.'</td>
	    					<td>'.$r->item_qty.'</td>
	    					<td>'.$r->item_total.'</td>
	    				  </tr>';
	    		$total_sprice +=$r->item_total;
	    	}
	    		$table .='</tbody>
		    				  <tfoot>
		    				  	<tr>
		    				  		<td>&nbsp;</td>
		    				  		<td>&nbsp;</td>
		    				  		<td>&nbsp;</td>
		    				  		<td>&nbsp;</td>
		    				  		<td>'.$total_sprice.'</td>
		    				  	</tr>
		    				  </tfoot>
	    				  </table>';
	    }
	    else
	    {
	    	$table = 'NO DATA TO DISPLAY';
	    }
	    echo json_encode([$table]);
	}

    public function stock_in(Request $request)
	{	
		if($request->sdate && $request->edate)
		{
			$sdate = $request->sdate;
			$edate = $request->edate;
		}
		else
		{
			$today = date('Y-m-d');
			$sdate = $today;
			$edate = $today;	
		}
        $query = StockIn::with('item')->whereDate('dated', '>=', $sdate)
            ->whereDate('dated', '<=', $edate)
            ->get();
		$data['stock_in'] = $query;
		$data['sdate']=$sdate;
		$data['edate']=$edate;

		return view('admin.report_stock_in',$data);
	}

    public function stock_out(Request $request)
	{	
		if($request->sdate && $request->edate)
		{
			$sdate = $request->sdate;
			$edate = $request->edate;
		}
		else
		{
			$today = date('Y-m-d');
			$sdate = $today;
			$edate = $today;	
		}
        $query = StockOut::with('item')->whereDate('dated', '>=', $sdate)
            ->whereDate('dated', '<=', $edate)
            ->get();
		$data['stock_out'] = $query;
		$data['sdate']=$sdate;
		$data['edate']=$edate;

		return view('admin.report_stock_out',$data);
	}

    public function stock_removed(Request $request)
    {	
    	if($request->sdate && $request->edate)
    	{
    		$sdate = $request->sdate;
    		$edate = $request->edate;
    	}       
    	else
    	{
    		$today = date('Y-m-d');
    		$sdate = $today;
    		$edate = $today;	
    	}
        $query = StockRemoved::with('item')->whereDate('dated', '>=', $sdate)
            ->whereDate('dated', '<=', $edate)
            ->get();
    	$data['stock_removed'] = $query;
    	$data['sdate']=$sdate;
    	$data['edate']=$edate;
        return view('admin.report_stock_removed',$data);
    }
    
    public function transfers(Request $request)
	{	
		$branch_ids ='';
		if($request->sdate && $request->edate)
		{
			$sdate = $request->sdate;
			$edate = $request->edate;
		}
		else
		{
			$today = date('Y-m-d');
			$sdate = $today;
			$edate = $today;	
		}
        $query = Transfers::with('branch');
		if($request->brnchk)
		{
			$branch_ids = $request->brnchk;
			$query->whereIn('branch_id',$branch_ids);
		}
		$query->whereDate('dated', '>=', $sdate);
		$query->whereDate('dated', '<=', $edate);
		$query = $query->get();
		$data['transfers'] = $query;
		$data['branch_ids']=$branch_ids;
        $data['branches'] = Branches::all();
		$data['sdate']=$sdate;
		$data['edate']=$edate;

		return view('admin.report_transfers',$data);
	}

    public function transfer_details(Request $request)
	{
 		$invoice     = $request->invoice;
        $q= TransferDetails::where('invoice', $invoice)->get();
	    if($q->count()>0)
	    {
	    	$sno=0;
	    	$total_sprice =0;
	    	$total_pprice =0;
	    	$table = '<table class="table">
	    				<thead>
	    					<tr>
	    						<th>Sno</th>
	    						<th>Item</th>
	    						<th>Price</th>
	    						<th>Qty</th>
	    						<th>Total</th>
	    					</tr>
	    				</thead>
	    				<tbody>';
	    	foreach($q as $r)
	    	{
	    		$sno++;
	    		$table .='<tr>
	    					<td>'.$sno.'</td>
	    					<td>'.$r->item_name.'</td>
	    					<td>'.$r->item_price.'</td>
	    					<td>'.$r->item_qty.'</td>
	    					<td>'.$r->item_total.'</td>
	    				  </tr>';
	    		$total_sprice +=$r->item_total;
	    	}
	    		$table .='</tbody>
		    				  <tfoot>
		    				  	<tr>
		    				  		<td>&nbsp;</td>
		    				  		<td>&nbsp;</td>
		    				  		<td>&nbsp;</td>
		    				  		<td>&nbsp;</td>
		    				  		<td>'.$total_sprice.'</td>
		    				  	</tr>
		    				  </tfoot>
	    				  </table>';
	    }
	    else
	    {
	    	$table = 'NO DATA TO DISPLAY';
	    }
	    echo json_encode([$table]);
	}

    public function expenses(Request $request)
	{
		$branch_ids ='';
		if($request->sdate && $request->edate)
		{
			$sdate = $request->sdate;
			$edate = $request->edate;
		}
		else
		{
			$today = date('Y-m-d');
			$sdate = $today;
			$edate = $today;	
		}
		$expense_query = Expenses::with(['branch','category']);
		if($request->expense_category)
		{
			$data['sexpense_category'] = $request->expense_category;
            $expense_query->where('category', $request->expense_category);
		}	
		else
		{
			$data['sexpense_category'] = "";
		}
		if($request->brnchk)
		{
			$branch_ids = $request->brnchk;
		}
        $expenses = $expense_query->whereDate('exp_date', '>=', $sdate)
		->whereDate('exp_date', '<=', $edate)
		->get();
		$data['sdate']=$sdate;
		$data['edate']=$edate;
        $query = ExpenseCategory::all();
        $data['expense_category'] = $query;
        $data['expenses'] = $expenses;
        $data['branches'] = Branches::all();
		$data['branch_ids']=$branch_ids;
		return view('admin.report_expenses',$data);
	}

    public function returns(Request $request)
	{	
		if($request->sdate && $request->edate)
		{
			$sdate = $request->sdate;
			$edate = $request->edate;
		}
		else
		{
			$today = date('Y-m-d');
			$sdate = $today;
			$edate = $today;	
		}
        $query = ReturnItems::whereDate('dated', '>=', $sdate)
            ->whereDate('dated', '<=', $edate)
            ->get();
		$data['returns'] = $query;
		$data['sdate']=$sdate;
		$data['edate']=$edate;

	    return view('admin.report_returns',$data);
	}

    public function quotations(Request $request)
	{	
		if($request->sdate && $request->edate)
		{
			$sdate = $request->sdate;
			$edate = $request->edate;
		}
		else
		{
			$today = date('Y-m-d');
			$sdate = $today;
			$edate = $today;	
		}
        $query = Quotations::with('customer')->whereDate('dated', '>=', $sdate)
            ->whereDate('dated', '<=', $edate)
            ->get();
        $data['quotations'] = $query;
        $data['sdate']=$sdate;
        $data['edate']=$edate;  
		$data['sdate']=$sdate;
		$data['edate']=$edate;

		return view('admin.report_quotations',$data);
	}

	public function quotation_details(Request $request)
	{
		$invoice     = $request->invoice;
	    $q = QuotationDetails::where('invoice', $invoice)->get();
	    if($q->count() > 0)
	    {
	    	$sno=0;
	    	$total_sprice =0;
	    	$table = '<table class="table">
	    				<thead>
	    					<tr>
	    						<th>Sno</th>
	    						<th>Item</th>
	    						<th>Price</th>
	    						<th>Qty</th>
	    						<th>Total</th>
	    					</tr>
	    				</thead>
	    				<tbody>';
	    	foreach($q as $r)
	    	{
	    		$sno++;
	    		$table .='<tr>
	    					<td>'.$sno.'</td>
	    					<td>'.$r->item_name.'</td>
	    					<td>'.$r->item_price.'</td>
	    					<td>'.$r->item_qty.'</td>
	    					<td>'.$r->item_total.'</td>
	    				  </tr>';
	    		$total_sprice +=$r->item_total;
	    	}
	    		$table .='</tbody>
		    				  <tfoot>
		    				  	<tr>
		    				  		<td>&nbsp;</td>
		    				  		<td>&nbsp;</td>
		    				  		<td>&nbsp;</td>
		    				  		<td>&nbsp;</td>
		    				  		<td>'.$total_sprice.'</td>
		    				  	</tr>
		    				  </tfoot>
	    				  </table>';
	    }
	    else
	    {
	    	$table = 'NO DATA TO DISPLAY';
	    }
	    echo json_encode([$table]);
	}

    public function special(Request $request)
	{
		if($request->sdate && $request->edate)
		{
			$sdate = $request->sdate;
			$edate = $request->edate;
		}
		else
		{
			$today = date('Y-m-d');
			$sdate = $today;
			$edate = $today;	
		}
		
        $sales_query = Sales::whereDate('dated', '>=', $sdate)
            ->whereDate('dated', '<=', $edate)
            ->selectRaw('SUM(grand_total) as grand_total')
            ->first();
        $total_sales = 0;
		if($sales_query)
		{
			$total_sales = $sales_query->grand_total;
		}

		$expense_query= Expenses::whereDate('exp_date', '>=', $sdate)
            ->whereDate('exp_date', '<=', $edate)
            ->selectRaw('SUM(exp_amount) as exp_amount')
            ->first();
		$total_expenses = 0;
		if($expense_query)
		{
			$total_expenses = $expense_query->exp_amount;
		}

		$purchase_query = Purchases::whereDate('dated', '>=', $sdate)
            ->whereDate('dated', '<=', $edate)
            ->selectRaw('SUM(sub_total) as sub_total')
            ->first();  
		$total_purchases = 0;
		if($purchase_query)
		{
			$total_purchases = $purchase_query->sub_total;
		}

		$return_query = ReturnItems::whereDate('dated', '>=', $sdate)
            ->whereDate('dated', '<=', $edate)
            ->selectRaw('SUM(item_total) as item_total')
            ->first();
        $total_returns = 0;
		if($return_query)
		{
			$total_returns = $return_query->item_total;
		}


		
		$data['sdate']=$sdate;
		$data['edate']=$edate;
		$data['total_sales'] =$total_sales;
		$data['total_expenses'] =$total_expenses;
		$data['total_purchases'] =$total_purchases;
		$data['total_returns'] =$total_returns;
        $data['difference'] = $total_sales - ($total_expenses + $total_purchases + $total_returns);
		return view('admin.report_special',$data);
	}
}
