
<?php $__env->startSection('content'); ?>
            
<form action="<?php echo e(route('report.transfers')); ?>" method="POST">
    <div class="row">
        <div class="col-sm-6">
            <?php echo csrf_field(); ?>
            <div class="row">
                <div class="form-group col-md-4">
                    <label><?php echo e(__('messages.start_date')); ?></label>
                    <input type="text" class="form-control datepickr" name="sdate"
                        value="<?php echo e($sdate); ?>">
                </div>
                <div class="form-group col-md-4 ">
                    <label><?php echo e(__('messages.end_date')); ?></label>
                    <input type="text" class="form-control datepickr" name="edate"
                        value="<?php echo e($edate); ?>">
                </div>
                <div class="col-md-4">
                    <button class="btn btn-primary mt-20" type="submit"> <?php echo e(__('messages.submit')); ?></button>
                </div>
            </div>
        </div>
        <div class="col-sm-6">
            <div class="row">
                <div class="col-12">
                    <h5 class="text-center"> Select Branch </h5>
                </div>
                <?php $__currentLoopData = $branches; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $br): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <?php if($branch_ids != ''): ?>
                        <?php if(in_array($br->branch_id, $branch_ids)): ?>
                            <div class="col-md-4">
                                <input type="checkbox" name="brnchk[]" class="mt-3" value="<?php echo e($br->branch_id); ?>" checked> <?php echo e($br->branch_name); ?>

                            </div>
                        <?php else: ?>
                            <div class="col-md-4">
                                <input type="checkbox" name="brnchk[]" class="mt-3" value="<?php echo e($br->branch_id); ?>"> <?php echo e($br->branch_name); ?>

                            </div>
                        <?php endif; ?>
                    <?php else: ?>
                        <div class="col-md-4">
                            <input type="checkbox" name="brnchk[]" class="mt-3" value="<?php echo e($br->branch_id); ?>"> <?php echo e($br->branch_name); ?>

                        </div>
                    <?php endif; ?>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </div>
        </div>
    </div>
</form>

<div class="row">
    <div class="col-12">
        <hr>
        <br>
    </div>
</div>

<div class="row">
    <div class="col-md-12">
        <table class="table MyTable" id="transfersTable">
            <thead>
                <tr>
                    <th> # </th>
                    <th> <?php echo e(__('messages.date/time')); ?> </th>
                    <th> <?php echo e(__('messages.start_date')); ?> </th>
                    <th> <?php echo e(__('messages.invoice')); ?> </th>
                    <th> <?php echo e(__('messages.total_items')); ?></th>
                </tr>
            </thead>
            <tbody>

                <?php
                    $total_items = 0;
                ?>
                <?php $__currentLoopData = $transfers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $trf): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <tr>
                        <td><?php echo e($loop->iteration); ?></td>
                        <td><?php echo e($trf->dated); ?></td>
                        <td><?php echo e($trf->branch->branch_name); ?></td>
                        <td>
                            <a href="#" id="<?php echo e($trf->invoice); ?>" data-toggle="modal" data-target="#trf-details"><?php echo e($trf->invoice); ?></a>
                        </td>
                        <td class="total_st"><?php echo e(intval($trf->total_items)); ?></td>
                    </tr>
                    <?php
                        $total_items += $trf->total_items;
                    ?>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

            </tbody>
            <tfoot>
                <tr>
                    <th>&nbsp;</th>
                    <th>&nbsp;</th>
                    <th>&nbsp;</th>
                    <th>&nbsp;</th>
                    <th><?php echo e(intval($total_items)); ?></th>
                </tr>
            </tfoot>
        </table>
    </div>
</div>

<div id="trf-details" class="modal fade" role="dialog">
<div class="modal-dialog modal-lg">
    <!-- Modal content-->
    <div class="modal-content">
        <div class="modal-header">
            <h5 class="modal-title"><?php echo e(__('messages.transfer')); ?> # : <span id="invoice_number"></span></h5>
            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                <span aria-hidden="true">&times;</span>
            </button>
        </div>
        <div class="modal-body" id="trf-mbody">

        </div>
        <div class="modal-footer">
            <button type="button" class="btn btn-default" data-dismiss="modal"><?php echo e(__('messages.close')); ?></button>
        </div>
    </div>
</div>
</div>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('customjs'); ?>
<script src="<?php echo e(asset('custom_js/reports.js')); ?>"></script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.template.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/craftada/iftikhar.appssoul.com/resources/views/admin/report_transfers.blade.php ENDPATH**/ ?>