
<?php $__env->startSection('content'); ?>
<form action="<?php echo e(route('report.returns')); ?>" method="POST">
    <div class="row">
        <div class="col-sm-6">
            <?php echo csrf_field(); ?>
            <div class="row">
                <div class="form-group col-md-4">
                    <label><?php echo e(__('messages.start_date')); ?></label>
                    <input type="text" class="form-control datepickr" name="sdate"
                        value="<?php echo e($sdate); ?>">
                </div>
                <div class="form-group col-md-4 ">
                    <label><?php echo e(__('messages.end_date')); ?></label>
                    <input type="text" class="form-control datepickr" name="edate"
                        value="<?php echo e($edate); ?>">
                </div>
                <div class="col-md-4">
                    <button class="btn btn-primary mt-20" type="submit"> <?php echo e(__('messages.submit')); ?></button>
                </div>
            </div>
        </div>
    </div>
</form>

<div class="row">
    <div class="col-12">
        <hr>
        <br>
    </div>
</div>

<div class="row">
    <div class="col-md-12">
        <table class="table MyTable">
            <thead>
                <tr>
                    <th> # </th>
                    <th> <?php echo e(__('messages.date/time')); ?> </th>
                    <th> <?php echo e(__('messages.invoice')); ?> </th>
                    <th> <?php echo e(__('messages.name')); ?>-<?php echo e(__('messages.barcode')); ?> </th>
                    <th> <?php echo e(__('messages.price')); ?> </th>
                    <th> <?php echo e(__('messages.quantity')); ?> </th>
                    <th> <?php echo e(__('messages.total')); ?> </th>
                </tr>
            </thead>
            <tbody>

                <?php
                    $total = 0;
                ?>
                <?php $__currentLoopData = $returns; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $rtn): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <tr>
                        <td><?php echo e($loop->iteration); ?></td>
                        <td><?php echo e($rtn->dated); ?></td>
                        <td><?php echo e($rtn->invoice); ?></td>
                        <td><?php echo e($rtn->item_name); ?></td>
                        <td><?php echo e($rtn->item_price); ?></td>
                        <td><?php echo e($rtn->item_qty); ?></td>
                        <td><?php echo e($rtn->item_total); ?></td>
                    </tr>
                    <?php
                        $total += $rtn->item_total;
                    ?>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </tbody>
            <tfoot>
                <tr>
                    <th>&nbsp;</th>
                    <th>&nbsp;</th>
                    <th>&nbsp;</th>
                    <th>&nbsp;</th>
                    <th>&nbsp;</th>
                    <th>&nbsp;</th>
                    <th><?php echo e(formatAmount($total)); ?></th>
                </tr>
            </tfoot>
        </table>
    </div>
</div>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('customjs'); ?>
<script src="<?php echo e(asset('custom_js/reports.js')); ?>"></script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.template.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/craftada/iftikhar.appssoul.com/resources/views/admin/report_returns.blade.php ENDPATH**/ ?>