@extends('admin.template.master')
@section('content')
    <div class="row">
        <div class="col-md-4">
            <div class="form-group">
                <label>{{__('messages.name')}}</label>
                <input type="text" name="spl_name" id="spl_name" class="form-control" placeholder="Name" />
            </div>
        </div>
        <div class="col-md-4">
            <div class="form-group">
                <label>{{__('messages.contact')}}</label>
                <input type="text" name="spl_contact" id="spl_contact" class="form-control isnumber"
                    placeholder="Contact" />
            </div>
        </div>
        <div class="col-md-4">
            <div class="form-group">
                <label>{{__('messages.email')}}</label>
                <input type="text" name="spl_email" id="spl_email" class="form-control"
                    placeholder="Email" />
            </div>
        </div>
        <div class="col-md-6">
            <div class="form-group">
                <label>{{__('messages.address')}}</label>
                <textarea class="form-control" name="spl_address" id="spl_address"></textarea>
            </div>
        </div>
        <div class="col-md-6">
            <div class="form-group">
                <label>{{__('messages.notes')}}</label>
                <textarea class="form-control" name="spl_notes" id="spl_notes"></textarea>
            </div>
        </div>
        <div class="col-md-12">
            <button type="button" id="btn-add-supplier" class="btn btn-success m-t-20">{{__('messages.add')}}</button>
            <span id="spl-msg"></span>
        </div>
    </div>

    <div class="row">
        <div class="col-md-12 mt-5">
            <table id="supplierTable" class="table table-striped table-bordered dt-responsive nowrap"
                cellspacing="0" width="100%">
                <thead>
                    <tr>
                        <th>#</th>
                        <th>{{__('messages.name')}}</th>
                        <th>{{__('messages.contact')}}</th>
                        <th>{{__('messages.email')}}</th>
                        <th>{{__('messages.address')}}</th>
                        <th>{{__('messages.notes')}}</th>
                        <th>{{__('messages.actions')}}</th>
                    </tr>
                </thead>
                <tbody>
                </tbody>
            </table>
        </div>
    </div>
       
   

    <div id="supplier-edit-modal" class="modal fade" role="dialog">
        <div class="modal-dialog modal-lg">
            <!-- Modal content-->
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title">{{__('messages.edit')}}</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body">
                    <div class="row">
                        <div class="col-md-4">
                            <input type="hidden" name="spl_id" id="e_spl_id">
                            <div class="form-group">
                                <label>{{__('messages.name')}}</label>
                                <input type="text" name="spl_name" id="e_spl_name" class="form-control"
                                    placeholder="Name" />
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="form-group">
                                <label>{{__('messages.contact')}}</label>
                                <input type="text" name="spl_contact" id="e_spl_contact" class="form-control"
                                    placeholder="Contact" />
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="form-group">
                                <label>{{__('messages.email')}}</label>
                                <input type="text" name="spl_email" id="e_spl_email" class="form-control"
                                    placeholder="Email" />
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label>{{__('messages.address')}}</label>
                                <textarea class="form-control" name="spl_address" id="e_spl_address"></textarea>
                            </div>
                            <span id="e_spl-msg"></span>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label>{{__('messages.notes')}}</label>
                                <textarea class="form-control" name="spl_notes" id="e_spl_notes"></textarea>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-default" data-dismiss="modal">{{__('messages.close')}}</button>
                    <button type="button" id="btn-update-supplier"
                        class="btn btn-primary waves-effect waves-light">{{__('messages.save_changes')}}</button>
                </div>
            </div>
        </div>
    </div>

    <!-- Invocies Modal -->
    <div id="supplier-invoices-modal" class="modal fade" role="dialog">
        <div class="modal-dialog modal-lg">
            <!-- Modal content-->
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title">{{__('messages.invoices')}}</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body" id="pinv-mbody">

                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-default" data-dismiss="modal">{{__('messages.close')}}</button>
                </div>
            </div>
        </div>
    </div>

    <!-- Payment Modal -->
    <div id="make-payment-modal" class="modal fade" role="dialog">
        <div class="modal-dialog modal-xl">
            <!-- Modal content-->
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title">{{__('messages.invoice')}} # : <span id="invoice_number"></span></h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body">
                    <div class="row">
                        <div class="col-md-3">
                            <label> {{__('messages.payment_amount')}} </label>
                            <input type="text" class="form-control isnumber" id="ptext">
                        </div>
                        <div class="col-md-3">
                            <label> {{__('messages.payment_type')}} </label>
                            <select class="form-control" id="pbank">
                                <option value="" selected> {{__('messages.choose')}} </option>
                                <option value="cash"> {{__('messages.cash')}} </option>
                                <option value="cheque"> {{__('messages.cheque')}} </option>
                                <option value="card"> {{__('messages.card')}} </option>
                            </select>
                        </div>
                        <div class="col-md-3">
                            <label> {{__('messages.document')}} # </label>
                            <input type="text" class="form-control" id="pcheque">
                        </div>
                        <div class="col-md-2">
                            <label> {{__('messages.document')}} {{__('messages.date')}}</label>
                            <input type="text" class="form-control datepickr" id="pchequed">
                        </div>
                        <div class="col-md-1">
                            <button class="btn btn-danger btn-block" style="margin-top:22px;" id="btn-make-payment"> {{__('messages.add')}}
                            </button>
                        </div>
                        <div class="col-md-12">
                            <table class="table sr mt-3">
                                <thead>
                                    <tr>
                                        <th> # </th>
                                        <th> {{__('messages.amount')}} </th>
                                        <th> {{__('messages.balance')}} </th>
                                        <th> {{__('messages.date/time')}} </th>
                                        <th> {{__('messages.payment_type')}} </th>
                                        <th> {{__('messages.document')}} # </th>
                                        <th> {{__('messages.document')}} {{__('messages.date')}} </th>
                                        <th> {{__('messages.delete')}} </th>
                                    </tr>
                                </thead>
                                <tbody id="payment-tbody">

                                </tbody>
                            </table>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-default" data-dismiss="modal">{{__('messages.close')}}</button>
                    </div>
                </div>
            </div>
        </div>
    </div>
    @endsection
    @section('customjs')
        <script src="{{ asset('custom_js/suppliers.js') }}"></script>
    @endsection
