@extends('admin.template.master')
@section('content')
<!-- Nav tabs -->
<ul class="nav nav-tabs nav-tabs-custom nav-justified" role="tablist">
    <li class="nav-item">
        <a class="nav-link active" data-toggle="tab" href="#new-transfer" role="tab">
            <span class="d-block d-sm-none"><i class="fas fa-home"></i></span>
            <span class="d-none d-sm-block"> {{__('messages.new_transfer')}}</span> 
        </a>
    </li>
    <li class="nav-item">
        <a class="nav-link" data-toggle="tab" href="#view-all" role="tab">
            <span class="d-block d-sm-none"><i class="far fa-user"></i></span>
            <span class="d-none d-sm-block"> {{__('messages.view_all')}}</span> 
        </a>
    </li>
</ul>
<!-- Tab panes -->
<div class="tab-content p-3 text-muted">
    <div class="tab-pane active" id="new-transfer" role="tabpanel">
        <div class="row">
            <div class="col-md-1">
                <p><span class="label label-info"> {{__('messages.transfer')}} {{__('messages.to')}} : </span></p>
            </div>
            @foreach ($branches as $br)
                <div class="col-md-1">
                    <input type="checkbox" class="trf_br_chk" value="{{ $br->branch_id }}">
                    {{ $br->branch_name }}
                </div>
            @endforeach

            <div class="col-md-2">
                <p><span class="label label-danger"> {{__('messages.transfer')}} {{__('messages.from')}} : </span></p>
            </div>
            <div class="col-md-1 text-left">
                <select id="select_from">
                    <option value="" selected> {{__('messages.choose')}} </option>
                    @foreach ($branches as $br)
                        <option value="{{ $br->branch_id }}">{{ $br->branch_name }}</option>
                    @endforeach
                </select>
            </div>
            <div class="col-md-1">
                <select id="select_to">
                    <option value="" selected> {{__('messages.choose')}} </option>
                    <option value="0"> {{__('messages.admin')}} </option>

                </select>
            </div>
        </div>
        <div class="row">
            <div class="form-group col-md-3">
                <label>{{__('messages.name')}}/{{__('messages.barcode')}}</label>
                <input type="text" name="prd_stk" id="prd_stk" class="form-control"
                    placeholder="" />
            </div>
            <div class="form-group col-md-3">
                <label>{{__('messages.quantity')}} <span id="prd_stk_unit"></span></label>
                <input type="text" name="prd_stk_qty" id="prd_stk_qty" class="form-control isnumber"
                    placeholder="" />
            </div>
            <div class="form-group col-md-1">
                <label>&nbsp;</label>
                <button type="button" id="btn-add-prd-stk-atl" class="btn btn-block btn-primary"><i
                        class="fa fa-plus"></i> </button>
            </div>
            <div class="form-group col-md-2">
                <label>&nbsp;</label>
                <button type="button" id="btn-process-items" class="btn btn-block btn-danger"><i
                        class="fa fa-check"></i> {{__('messages.process')}}</button>
            </div>
            <div class="form-group col-md-2">
                <label>&nbsp;</label>
                <p id="req-msg" class="text-danger"></p>
            </div>
        </div>
        <div class="row">
            <div class="col-md-12">
                <table id="" class="table table-striped table-bordered dt-responsive nowrap sr"
                    cellspacing="0" width="100%">
                    <thead>
                        <tr>
                            <th>#</th>
                            <th>{{__('messages.name')}}-{{__('messages.barcode')}}</th>
                            <th>{{__('messages.quantity')}}</th>
                            <th>{{__('messages.unit_price')}}</th>
                            <th>{{__('messages.total_price')}}</th>
                            <th>{{__('messages.remove')}}</th>
                        </tr>
                    </thead>
                    <tbody id="prd_stk_tbody">

                    </tbody>
                    <tfoot>
                        <tr>
                            <th colspan="4">{{__('messages.total')}}</th>
                            <th id="sub_total"></th>
                            <th>&nbsp;</th>
                        </tr>
                    </tfoot>
                </table>
            </div>
        </div>
    </div>
    <div class="tab-pane" id="view-all" role="tabpanel">
        <div class="row">
            <div class="col-md-12">
                <table id="transferTable"
                    class="table table-striped table-bordered dt-responsive nowrap" style="width:100%;">
                    <thead>
                        <tr>
                            <th>#</th>
                            <th>{{__('messages.invoice')}} #</th>
                            <th>{{__('messages.branch')}} {{__('messages.from')}}</th>
                            <th>{{__('messages.branch')}} {{__('messages.to')}}</th>
                            <th>{{__('messages.total_items')}}</th>
                            <th>{{__('messages.date/time')}} </th>
                            <th>{{__('messages.print')}}</th>
                        </tr>
                    </thead>
                    <tbody>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</div>  


<div id="trf-details" class="modal fade" role="dialog">
    <div class="modal-dialog modal-lg">
        <!-- Modal content-->
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">{{__('messages.transfer')}}</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body" id="trf-mbody">

            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-default" data-dismiss="modal">{{__('messages.close')}}</button>
            </div>
        </div>
    </div>
</div>
@endsection
@section('customjs')
    <script src="{{ asset('custom_js/transfer_scripts.js') }}"></script>
@endsection
