@extends('admin.template.master')
@section('content')
            
<form action="{{ route('report.transfers') }}" method="POST">
    <div class="row">
        <div class="col-sm-6">
            @csrf
            <div class="row">
                <div class="form-group col-md-4">
                    <label>{{__('messages.start_date')}}</label>
                    <input type="text" class="form-control datepickr" name="sdate"
                        value="{{ $sdate }}">
                </div>
                <div class="form-group col-md-4 ">
                    <label>{{__('messages.end_date')}}</label>
                    <input type="text" class="form-control datepickr" name="edate"
                        value="{{ $edate }}">
                </div>
                <div class="col-md-4">
                    <button class="btn btn-primary mt-20" type="submit"> {{__('messages.submit')}}</button>
                </div>
            </div>
        </div>
        <div class="col-sm-6">
            <div class="row">
                <div class="col-12">
                    <h5 class="text-center"> Select Branch </h5>
                </div>
                @foreach ($branches as $br)
                    @if ($branch_ids != '')
                        @if (in_array($br->branch_id, $branch_ids))
                            <div class="col-md-4">
                                <input type="checkbox" name="brnchk[]" class="mt-3" value="{{ $br->branch_id }}" checked> {{ $br->branch_name }}
                            </div>
                        @else
                            <div class="col-md-4">
                                <input type="checkbox" name="brnchk[]" class="mt-3" value="{{ $br->branch_id }}"> {{ $br->branch_name }}
                            </div>
                        @endif
                    @else
                        <div class="col-md-4">
                            <input type="checkbox" name="brnchk[]" class="mt-3" value="{{ $br->branch_id }}"> {{ $br->branch_name }}
                        </div>
                    @endif
                @endforeach
            </div>
        </div>
    </div>
</form>

<div class="row">
    <div class="col-12">
        <hr>
        <br>
    </div>
</div>

<div class="row">
    <div class="col-md-12">
        <table class="table MyTable" id="transfersTable">
            <thead>
                <tr>
                    <th> # </th>
                    <th> {{__('messages.date/time')}} </th>
                    <th> {{__('messages.start_date')}} </th>
                    <th> {{__('messages.invoice')}} </th>
                    <th> {{__('messages.total_items')}}</th>
                </tr>
            </thead>
            <tbody>

                @php
                    $total_items = 0;
                @endphp
                @foreach ($transfers as $trf)
                    <tr>
                        <td>{{ $loop->iteration }}</td>
                        <td>{{ $trf->dated }}</td>
                        <td>{{ $trf->branch->branch_name }}</td>
                        <td>
                            <a href="#" id="{{ $trf->invoice }}" data-toggle="modal" data-target="#trf-details">{{ $trf->invoice }}</a>
                        </td>
                        <td class="total_st">{{ intval($trf->total_items) }}</td>
                    </tr>
                    @php
                        $total_items += $trf->total_items;
                    @endphp
                @endforeach

            </tbody>
            <tfoot>
                <tr>
                    <th>&nbsp;</th>
                    <th>&nbsp;</th>
                    <th>&nbsp;</th>
                    <th>&nbsp;</th>
                    <th>{{ intval($total_items) }}</th>
                </tr>
            </tfoot>
        </table>
    </div>
</div>

<div id="trf-details" class="modal fade" role="dialog">
<div class="modal-dialog modal-lg">
    <!-- Modal content-->
    <div class="modal-content">
        <div class="modal-header">
            <h5 class="modal-title">{{__('messages.transfer')}} # : <span id="invoice_number"></span></h5>
            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                <span aria-hidden="true">&times;</span>
            </button>
        </div>
        <div class="modal-body" id="trf-mbody">

        </div>
        <div class="modal-footer">
            <button type="button" class="btn btn-default" data-dismiss="modal">{{__('messages.close')}}</button>
        </div>
    </div>
</div>
</div>
@endsection
@section('customjs')
<script src="{{ asset('custom_js/reports.js') }}"></script>
@endsection
