@extends('admin.template.master')
@section('content')

<form action="{{ route('report.stock-out') }}" method="POST">
    <div class="row">
        <div class="col-sm-6">
            @csrf
            <div class="row">
                <div class="form-group col-md-4">
                    <label>{{__('messages.start_date')}}</label>
                    <input type="text" class="form-control datepickr" name="sdate"
                        value="{{ $sdate }}">
                </div>
                <div class="form-group col-md-4 ">
                    <label>{{__('messages.end_date')}}</label>
                    <input type="text" class="form-control datepickr" name="edate"
                        value="{{ $edate }}">
                </div>
                <div class="col-md-4">
                    <button class="btn btn-primary mt-20" type="submit"> Submit</button>
                </div>
            </div>
        </div>
    </div>
</form>

<div class="row">
    <div class="col-12">
        <hr>
        <br>
    </div>
</div>

<div class="row">
    <div class="col-md-12">
        <table class="table MyTable">
            <thead>
                <tr>
                    <th> # </th>
                    <th> {{__('messages.date')}}</th>
                    <th> {{__('messages.items')}} </th>
                    <th> {{__('messages.quantity')}} </th>
                    <th> {{__('messages.notes')}} </th>
                </tr>
            </thead>
            <tbody>

                @foreach ($stock_out as $so)
                    <tr>
                        <td>{{ $loop->iteration }}</td>
                        <td>{{ $so->stk_date }}</td>
                        <td>{{ $so->item->stk_name }}-{{ $so->stk_item }}</td>
                        <td>{{ str_replace(',', '', number_format($so->stk_quantity)) }}</td>
                        <td>{{ $so->reason }}</td>
                    </tr>
                @endforeach


            </tbody>
            <tfoot>
                <th>&nbsp;</th>
                <th>&nbsp;</th>
                <th>&nbsp;</th>
                <th>&nbsp;</th>
                <th>&nbsp;</th>
            </tfoot>
        </table>
    </div>
</div>

@endsection
@section('customjs')
<script src="{{ asset('custom_js/reports.js') }}"></script>
@endsection
