@extends('admin.template.master')
@section('content')
<form action="{{ route('report.sales') }}" method="POST">
    <div class="row">
        <div class="col-sm-6">
            @csrf
            <div class="row">
                <div class="form-group col-md-4">
                    <label>{{__('messages.start_date')}}</label>
                    <input type="text" class="form-control datepickr" name="sdate"
                        value="{{ $sdate }}">
                </div>
                <div class="form-group col-md-4 ">
                    <label>{{__('messages.end_date')}}</label>
                    <input type="text" class="form-control datepickr" name="edate"
                        value="{{ $edate }}">
                </div>
                <div class="col-md-4">
                    <button class="btn btn-primary mt-20" type="submit"> {{__('messages.submit')}}</button>
                </div>
            </div>
        </div>
        <div class="col-sm-6">
            <div class="row">
                <div class="col-12">
                    <h5 class="text-center"> Select Branch </h5>
                </div>
                @foreach ($branches as $br)
                    @if ($branch_ids != '')
                        @if (in_array($br->branch_id, $branch_ids))
                            <div class="    ">
                                <input type="checkbox" name="brnchk[]" class="mt-3" value="{{ $br->branch_id }}" checked> {{ $br->branch_name }}
                            </div>
                        @else
                            <div class="col-md-4">
                                <input type="checkbox" name="brnchk[]" class="mt-3" value="{{ $br->branch_id }}"> {{ $br->branch_name }}
                            </div>
                        @endif
                    @else
                        <div class="col-md-4 text-center">
                            <input type="checkbox" name="brnchk[]" class="mt-3" value="{{ $br->branch_id }}"> {{ $br->branch_name }}
                        </div>
                    @endif
                @endforeach
            </div>
        </div>
    </div>
</form>

<div class="row">
    <div class="col-12">
        <hr>
        <br>
    </div>
</div>

<div class="row">
    <div class="col-md-12">
        <table class="table" id="salesTable">
            <thead>
                <tr>
                    <th> # </th>
                    <th> {{__('messages.date/time')}} </th>
                    <th> {{__('messages.branch')}} </th>
                    <th> {{__('messages.invoice')}} </th>
                    <th> {{__('messages.payment_type')}} </th>
                    <th> {{__('messages.sub_total')}} </th>
                    <th> {{__('messages.discount')}} </th>
                    <th> {{__('messages.grand_total')}} </th>
                    <th> {{__('messages.purchases')}} </th>
                    <th> {{__('messages.difference')}} </th>
                    <th> {{__('messages.invoice')}} </th>
                </tr>
            </thead>
            <tbody>
                @php
                    $sno = 0;
                    $total_st = 0;
                    $total_ds = 0;
                    $total_gt = 0;
                    $total_ph = 0;
                @endphp
                @foreach ($sales as $sls)
                    @php$sno++;@endphp
                    <tr>
                        <td>{{ $loop->iteration }}</td>
                        <td>{{ $sls->dated }}</td>
                        <td>{{ $sls->branch->branch_name }}</td>
                        <td>
                            <a href="#" id="{{ $sls->invoice }}" data-toggle="modal"
                                data-target="#sinvoice-details">{{ $sls->invoice }}</a>
                        </td>
                        <td>{{ $sls->payment_type }}</td>
                        <td class="total_st">{{ $sls->sub_total }}</td>
                        <td class="total_ds">{{ $sls->discount }}</td>
                        <td class="total_gt">{{ $sls->grand_total }}</td>
                        <td class="total_ph">{{ $sls->purchases }}</td>
                        <td class="total_diff">{{ formatAmount($sls->grand_total - $sls->purchases) }}
                        </td>
                        <td><a href="{{ route('sales.invoice', ['id' => $sls->invoice]) }}"
                                target="_blank"><i class="fa fa-print"></i></a></td>
                    </tr>
                @endforeach
            </tbody>
            <tfoot>
                <tr>
                    <th>&nbsp;</th>
                    <th>&nbsp;</th>
                    <th>&nbsp;</th>
                    <th>&nbsp;</th>
                    <th>&nbsp;</th>
                    <th class="text-purple" id="total_st"></th>
                    <th class="text-warning" id="total_ds"></th>
                    <th class="text-success" id="total_gt"></th>
                    <th class="text-danger" id="total_ph"></th>
                    <th class="text-info" id="total_diff"></th>
                    <th>&nbsp;</th>
                </tr>
            </tfoot>
        </table>
    </div>
</div>

<div id="sinvoice-details" class="modal fade" role="dialog">
    <div class="modal-dialog modal-lg">
        <!-- Modal content-->
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">{{__('messages.invoice')}} : <span id="invoice_number"></span></h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body" id="sinvoice-mbody">

            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-default" data-dismiss="modal">{{__('messages.close')}}</button>
            </div>
        </div>
    </div>
</div>
@endsection
@section('customjs')
    <script src="{{ asset('custom_js/reports.js') }}"></script>
@endsection
