@extends('admin.template.master')
@section('content')
    <div class="row">
        <div class="col-md-12">
            <p id="exp_err_msg"></p>
        </div>
        <div class="col-md-6">
            <div class="form-group">
                <label for="expense_category">{{__('messages.expense_category')}}</label>
                <select class="form-control" id="expense_category" name="expense_category">
                    <option value="" selected> {{__('messages.choose')}} </option>
                    @foreach ($categories as $ec)
                        <option value="{{ $ec->category_id }}">{{ $ec->category_name }}</option>
                    @endforeach
                </select>
            </div>
        </div>
        <div class="col-md-6">
            <div class="form-group">
                <label for="expense_branch">{{__('messages.branch')}} </label>
                <select class="form-control" id="expense_branch" name="expense_branch">
                    <option value="" selected> {{__('messages.choose')}} </option>
                    <option value="0">{{__('messages.general')}}</option>
                    @foreach ($branches as $br)
                        <option value="{{ $br->branch_id }}">{{ $br->branch_name }}</option>
                    @endforeach
                </select>
            </div>
        </div>
    </div>
    <div class="row">
        <div class="col-md-4">
            <div class="form-group">
                <label for="expense_title">{{__('messages.title')}} </label>
                <input type="text" class="form-control" id="expense_title" name="expense_title"
                    placeholder="Title">
            </div>
        </div>
        <div class="col-md-4">
            <div class="form-group">
                <label for="expense_amount">{{__('messages.amount')}}</label>
                <input type="text" class="form-control isnumber" id="expense_amount" name="expense_amount"
                    placeholder="Amount">
            </div>
        </div>
        <div class="col-md-4">
            <div class="form-group">
                <label for="expense_date">{{__('messages.date')}}</label>
                <input type="text" class="form-control" id="expense_date" name="expense_date"
                    placeholder="yyyy-mm-dd">
            </div>
        </div>
    </div>
    <div class="row">
        <div class="col-md-6">
            <div class="form-group">
                <label for="payment_type">{{__('messages.payment_type')}} </label>
                <select class="form-control" id="payment_type" name="payment_type">
                    <option value="" selected>{{__('messages.choose')}} </option>
                    <option value="cash"> {{__('messages.cash')}} </option>
                    <option value="cheque"> {{__('messages.cheque')}} </option>
                    <option value="card"> {{__('messages.card')}} </option>
                </select>
            </div>
        </div>
        <div class="col-md-6">
            <div class="form-group">
                <label for="expense_title">{{__('messages.cheque')}} # </label>
                <input type="text" class="form-control" id="cheque_number" name="cheque_number"
                    placeholder="Cheque Number">
            </div>
        </div>
    </div>
    <div class="row">
        <div class="col-md-12">
            <div class="form-group">
                <label for="expense_notes">{{__('messages.notes')}}</label>
                <textarea class="form-control" id="expense_notes" name="expense_notes" placeholder="Notes"></textarea>
            </div>
        </div>
    </div>
    <div class="row">
        <div class="col-md-12">
            <div class="form-group">
                <input type="button" class="btn btn-info m-t-10" id="btn_add_expense" name="btn_add_expense"
                    value="{{__('messages.add')}}">
            </div>
        </div>
    </div>


    <table id="expensesTable" class="table table-striped table-bordered dt-responsive nowrap" cellspacing="0"
        width="100%">
        <thead>
            <tr>
                <th>#</th>
                <th>{{__('messages.branch')}}</th>
                <th>{{__('messages.category')}}</th>
                <th>{{__('messages.title')}}</th>
                <th>{{__('messages.date')}}</th>
                <th>{{__('messages.amount')}}</th>
                <th>{{__('messages.payment_type')}}</th>
                <th>{{__('messages.cheque')}} #</th>
                <th>{{__('messages.notes')}}</th>
                <th>{{__('messages.date/time')}}</th>
                <th>{{__('messages.actions')}}</th>
            </tr>
        </thead>
        <tbody>

        </tbody>

    </table>
    
    <div id="expense-edit-modal" class="modal fade" role="dialog">
        <div class="modal-dialog">
            <!-- Modal content-->
            <div class="modal-content">
                <div class="modal-header">
                    <button type="button" class="modal-close" data-dismiss="modal">
                        <i class="font-icon-close-2"></i>
                    </button>
                    <h4 class="modal-title">{{__('messages.edit')}}</h4>
                </div>
                <div class="modal-body">
                    <div class="row">
                        <div class="col-md-12">
                            <p id="e_exp_err_msg"></p>
                        </div>
                        <div class="col-md-6">

                            <input type="hidden" name="exp_id" id="e_exp_id">
                            <div class="form-group">
                                <label for="e_expense_category">{{__('messages.expense_category')}} </label>
                                <select class="form-control" id="e_expense_category" name="expense_category">
                                    @foreach ($categories as $ec)
                                        <option value="{{ $ec->category_id }}">{{ $ec->category_name }}</option>
                                    @endforeach
                                </select>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="e_expense_branch">{{__('messages.branch')}} </label>
                                <select class="form-control" id="e_expense_branch" name="expense_branch">
                                    <option value="0">{{__('messages.general')}}</option>
                                    @foreach ($branches as $br)
                                        <option value="{{ $br->branch_id }}">{{ $br->branch_name }}</option>
                                    @endforeach
                                </select>
                            </div>
                        </div>
                    </div>
                    <div class="row">
                        <div class="form-group col-md-12">
                            <label for="expense_title">{{__('messages.title')}}</label>
                            <input type="text" class="form-control" id="e_expense_title" name="expense_title"
                                placeholder="Title">
                        </div>
                        <div class="form-group col-md-12">
                            <label for="expense_amount">{{__('messages.amount')}}</label>
                            <input type="text" class="form-control isnumber" id="e_expense_amount"
                                name="expense_amount" placeholder="Amount">
                        </div>
                        <div class="form-group col-md-12">
                            <label for="expense_date">{{__('messages.date')}}</label>
                            <input type="text" class="form-control datepicker" id="e_expense_date"
                                name="expense_date" placeholder="yyyy-mm-dd">
                        </div>
                        <div class="form-group col-md-12">
                            <label for="expense_notes">{{__('messages.notes')}}</label>
                            <textarea class="form-control" id="e_expense_notes" name="e_expense_notes" placeholder="Notes"></textarea>
                        </div>
                    </div>
                    <span id="e_item-msg"></span>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-default" data-dismiss="modal">{{__('messages.close')}}</button>
                    <button type="button" id="btn_update_expense" class="btn btn-primary waves-effect waves-light">{{__('messages.save_changes')}}</button>
                </div>
            </div>
        </div>
    </div>
   
@endsection
@section('customjs')
    <script src="{{ asset('custom_js/expenses.js') }}"></script>
@endsection
