@extends('admin.template.master')
@section('content')
    <div class="row">
        <div class="col-md-3">
            <div class="card mini-stats-wid box-border">
                <div class="card-body">
                    <div class="media">
                        <div class="media-body">
                            <p class="text-muted font-weight-medium">{{__('messages.ts')}}</p>
                            <h4 class="mb-0">{{formatAmount($sales['total'])}}</h4>
                        </div>

                        <div class="mini-stat-icon avatar-sm rounded-circle bg-primary align-self-center">
                            <span class="avatar-title">
                                <i class="fas fa-money-bill-alt font-size-24"></i>
                            </span>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="col-md-3">
            <div class="card mini-stats-wid box-border">
                <div class="card-body">
                    <div class="media">
                        <div class="media-body">
                            <p class="text-muted font-weight-medium">{{__('messages.tp')}}</p>
                            <h4 class="mb-0">{{formatAmount($purchases['total'])}}</h4>
                        </div>

                        <div class="mini-stat-icon avatar-sm rounded-circle bg-primary align-self-center">
                            <span class="avatar-title">
                                <i class="bx bx-copy-alt font-size-24"></i>
                            </span>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        
        <div class="col-md-3">
            <div class="card mini-stats-wid box-border">
                <div class="card-body">
                    <div class="media">
                        <div class="media-body">
                            <p class="text-muted font-weight-medium">{{__('messages.te')}}</p>
                            <h4 class="mb-0">{{formatAmount($expenses['total'])}}</h4>
                        </div>

                        <div class="mini-stat-icon avatar-sm rounded-circle bg-primary align-self-center">
                            <span class="avatar-title">
                                <i class="mdi mdi-wallet-outline font-size-24"></i>
                            </span>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        
        <div class="col-md-3">
            <div class="card mini-stats-wid box-border">
                <div class="card-body">
                    <div class="media">
                        <div class="media-body">
                            <p class="text-muted font-weight-medium">{{__('messages.tpl')}}</p>
                            <h4 class="mb-0">{{ formatAmount($sales['total']-($purchases['total']+$expenses['total'])) }}</h4>
                        </div>

                        <div class="mini-stat-icon avatar-sm rounded-circle bg-primary align-self-center">
                            <span class="avatar-title">
                                <i class="bx bxs-pie-chart-alt font-size-24"></i>
                            </span>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="row">
        <div class="col-md-3">
            <div class="card mini-stats-wid box-border">
                <div class="card-body">
                    <div class="media">
                        <div class="media-body">
                            <p class="text-muted font-weight-medium">{{__('messages.ms')}}</p>
                            <h4 class="mb-0">{{formatAmount($sales['monthly'])}}</h4>
                        </div>

                        <div class="mini-stat-icon avatar-sm rounded-circle bg-primary align-self-center">
                            <span class="avatar-title">
                                <i class="fas fa-money-bill-alt font-size-24"></i>
                            </span>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="col-md-3">
            <div class="card mini-stats-wid box-border">
                <div class="card-body">
                    <div class="media">
                        <div class="media-body">
                            <p class="text-muted font-weight-medium">{{__('messages.mp')}}</p>
                            <h4 class="mb-0">{{formatAmount($purchases['monthly'])}}</h4>
                        </div>

                        <div class="mini-stat-icon avatar-sm rounded-circle bg-primary align-self-center">
                            <span class="avatar-title">
                                <i class="bx bx-copy-alt font-size-24"></i>
                            </span>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        
        <div class="col-md-3">
            <div class="card mini-stats-wid box-border">
                <div class="card-body">
                    <div class="media">
                        <div class="media-body">
                            <p class="text-muted font-weight-medium">{{__('messages.me')}}</p>
                            <h4 class="mb-0">{{formatAmount($expenses['monthly'])}}</h4>
                        </div>

                        <div class="mini-stat-icon avatar-sm rounded-circle bg-primary align-self-center">
                            <span class="avatar-title">
                                <i class="mdi mdi-wallet-outline font-size-24"></i>
                            </span>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        
        <div class="col-md-3">
            <div class="card mini-stats-wid box-border">
                <div class="card-body">
                    <div class="media">
                        <div class="media-body">
                            <p class="text-muted font-weight-medium">{{__('messages.mpl')}}</p>
                            <h4 class="mb-0">{{ formatAmount($sales['monthly']-($purchases['monthly']+$expenses['monthly'])) }}</h4>
                        </div>

                        <div class="mini-stat-icon avatar-sm rounded-circle bg-primary align-self-center">
                            <span class="avatar-title">
                                <i class="bx bxs-pie-chart-alt font-size-24"></i>
                            </span>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
   
    <div class="row">
        <div class="col-md-3">
            <div class="card mini-stats-wid box-border">
                <div class="card-body">
                    <div class="media">
                        <div class="media-body">
                            <p class="text-muted font-weight-medium">{{__('messages.ds')}}</p>
                            <h4 class="mb-0">{{formatAmount($sales['daily'])}}</h4>
                        </div>

                        <div class="mini-stat-icon avatar-sm rounded-circle bg-primary align-self-center">
                            <span class="avatar-title">
                                <i class="fas fa-money-bill-alt font-size-24"></i>
                            </span>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="col-md-3">
            <div class="card mini-stats-wid box-border">
                <div class="card-body">
                    <div class="media">
                        <div class="media-body">
                            <p class="text-muted font-weight-medium">{{__('messages.dp')}}</p>
                            <h4 class="mb-0">{{formatAmount($purchases['daily'])}}</h4>
                        </div>

                        <div class="mini-stat-icon avatar-sm rounded-circle bg-primary align-self-center">
                            <span class="avatar-title">
                                <i class="bx bx-copy-alt font-size-24"></i>
                            </span>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        
        <div class="col-md-3">
            <div class="card mini-stats-wid box-border">
                <div class="card-body">
                    <div class="media">
                        <div class="media-body">
                            <p class="text-muted font-weight-medium">{{__('messages.de')}}</p>
                            <h4 class="mb-0">{{formatAmount($expenses['daily'])}}</h4>
                        </div>

                        <div class="mini-stat-icon avatar-sm rounded-circle bg-primary align-self-center">
                            <span class="avatar-title">
                                <i class="mdi mdi-wallet-outline font-size-24"></i>
                            </span>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        
        <div class="col-md-3">
            <div class="card mini-stats-wid box-border">
                <div class="card-body">
                    <div class="media">
                        <div class="media-body">
                            <p class="text-muted font-weight-medium">{{__('messages.dpl')}}</p>
                            <h4 class="mb-0">{{ formatAmount($sales['daily']-($purchases['daily']+$expenses['daily'])) }}</h4>
                        </div>

                        <div class="mini-stat-icon avatar-sm rounded-circle bg-primary align-self-center">
                            <span class="avatar-title">
                                <i class="bx bxs-pie-chart-alt font-size-24"></i>
                            </span>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
   
    
   
    
    <div class="row">
        <div class="col-md-12">
            <table class="table table-bordered table-striped">
                <thead>
                    <tr>
                        <th>#</th>
                        <th>{{__('messages.date/time')}}</th>
                        <th>{{__('messages.branch')}}</th>
                        <th>{{__('messages.invoice')}}</th>
                        <th>{{__('messages.payment_type')}}</th>
                        <th>{{__('messages.sub_total')}}</th>
                        <th>{{__('messages.discount')}}</th>
                        <th>{{__('messages.grand_total')}}</th>
                        <th>{{__('messages.print')}}</th>
                    </tr>
                </thead>
                <tbody>
                    @foreach($lastTenSales as $sale)
                        <tr>
                            <td>{{ $loop->iteration }}</td>
                            <td>{{ $sale->dated }}</td>
                            <td>{{ $sale->branch->branch_name }}</td>
                            <td>{{ $sale->invoice }}</td>
                            <td>{{ $sale->payment_type }}</td>
                            <td>{{ formatAmount($sale->sub_total) }}</td>
                            <td>{{ formatAmount($sale->discount) }}</td>
                            <td>{{ formatAmount($sale->grand_total) }}</td>
                            <td><a href="{{route('sales.invoice',['id'=>$sale->invoice])}}" target="_blank" class="text-primary"><i class="fa fa-print"></i></a></td>
                        </tr>
                    @endforeach
                </tbody>

            </table>
        </div>
    </div>
@endsection
@section('customjs')
@endsection
