$(document).ready(function(){

	$('#usersTable').DataTable({
		ajax: {
            url:  base_url+'users/show',
            type: "GET", // or 'POST' if needed
        },
        language: {
            lengthMenu: "_MENU_",
        },
        pageLength: 100,
        order: [],
        responsive: true,
    	
    });

	$('#branch_id').on('change',function(e){
		if($(this).val()==0)
		{
			$('.pchk').prop('disabled',false);
		}
		else
		{
			$('.pchk').prop('disabled',true);
			$('.pchk').prop('checked',false);
		}
	});

	$('#e_branch_id').on('change',function(e){
		if($(this).val()==0)
		{
			$('.epchk').prop('disabled',false);
		}
		else
		{
			$('.epchk').prop('disabled',true);
			$('.epchk').prop('checked',false);
		}
	});

	$('#btn-add-users').on('click',function(e){
		$('#msg_username').removeClass();
		$('#msg_userpass').removeClass();
		$('#msg_userbranch').removeClass();
		$('#msg_username').html("");
		$('#msg_userpass').html("");
		$('#msg_userbranch').html("");
		var username = $('#username').val();
		var userpass = $('#userpass').val();
		var branch_id= $('#branch_id').val();
		var permission={};
		$('.pchk').each(function(e){
			if($(this).is(':checked'))
			{
				permission[$(this).val()]=1;
			}
			else
			{
				permission[$(this).val()]=0;	
			}
		});
		if(username=="")
		{
			$('#msg_username').html('Required').addClass('text-danger').fadeIn('slow');
			return false;
		}
		if(userpass=="")
		{
			$('#msg_userpass').html('Required').addClass('text-danger').fadeIn('slow');
			return false;
		}
		if(branch_id=="")
		{
			$('#msg_userbranch').html('Required').addClass('text-danger').fadeIn('slow');
			return false;
		}
		
		var form_data    = new FormData();
		form_data.append('username',username);
		form_data.append('userpass',userpass);
		form_data.append('branch_id',branch_id);
		form_data.append('permission',JSON.stringify(permission));
		$.ajax({
			url:base_url+'users/add',
			type:'POST',
			processData:false,
			contentType: false,
		    data:form_data,
			success:function(response)
			{
				var res = $.parseJSON(response);
				if(res[0]==1)
				{
					notify('success','Added');
			      	$('#username').val("");
			      	$('#userpass').val("");
			      	$('#branch_id').val("");
			      	$('.pchk').prop('disabled',true);
			      	$('.pchk').prop('checked',false);
			    }
				else if(res[1]==3)
				{
					notify('warning','User Already Exists');
				}
				else
				{
					notify('error','Error try again');
				}
				$('#usersTable').DataTable().ajax.reload();
			}
		});
	});

	$('#user-edit-modal').on('show.bs.modal',function(e){
		var user_id = e.relatedTarget.id;
		$('#e_user_id').val(user_id);
		$('.epchk').prop('checked',false);
		var form_data    = new FormData();
		form_data.append('user_id',user_id);
		$.ajax({
			url:base_url+'users/edit',
			type:'POST',
			processData:false,
			contentType: false,
			data:form_data,
			success:function(msg)
			{
				var res = $.parseJSON(msg);
				$('#e_username').val(res['username']);
				$('#e_userpass').val(res['userpass']);
				$('#e_branch_id').val(res['branch_id']);
				if(res['sales']==1){$('#per_sales').prop('checked',true);}
				if(res['purchase']==1){$('#per_purchase').prop('checked',true);}
				if(res['stock']==1){$('#per_stock').prop('checked',true);}
				if(res['expense']==1){$('#per_expenses').prop('checked',true);}
				if(res['services']==1){$('#per_services').prop('checked',true);}
				if(res['offers']==1){$('#per_offers').prop('checked',true);}
				if(res['employees']==1){$('#per_employees').prop('checked',true);}
				if(res['users']==1){$('#per_users').prop('checked',true);}
				if(res['customers']==1){$('#per_customers').prop('checked',true);}
				if(res['invoice_header']==1){$('#per_invoice_header').prop('checked',true);}
				if(res['db_backup']==1){$('#per_db_backup').prop('checked',true);}
				if(res['reports']==1){$('#per_reports').prop('checked',true);}	
				if(res['stk_actions']==1){$('#per_stk_actions').prop('checked',true);}	
				if(res['quotations']==1){$('#per_quotations').prop('checked',true);}
				if(res['dashboard']==1){$('#per_dashboard').prop('checked',true);}
				$('#e_branch_id').trigger('change');
			}
		});
	});

	$('#btn-update-users').on('click',function(e){
		$('#msg_e_username').removeClass();
		$('#msg_e_userpass').removeClass();
		$('#msg_e_userbranch').removeClass();
		$('#msg_e_username').html("");
		$('#msg_e_userpass').html("");
		$('#msg_e_userbranch').html("");
		var user_id =$('#e_user_id').val();
		var username = $('#e_username').val();
		var userpass = $('#e_userpass').val();
		var branch_id = $('#e_branch_id').val();
		if(username=="")
		{
			$('#msg_e_username').html('Required').addClass('text-danger').fadeIn('slow');
			return false;
		}
		if(userpass=="")
		{
			$('#msg_e_userpass').html('Required').addClass('text-danger').fadeIn('slow');
			return false;
		}
		if(branch_id=="")
		{
			$('#msg_e_userbranch').html('Required').addClass('text-danger').fadeIn('slow');
			return false;
		}
		var permission={};
		$('.epchk').each(function(e){
			if($(this).is(':checked'))
			{
				permission[$(this).val()]=1;
			}
			else
			{
				permission[$(this).val()]=0;	
			}
		});
		var form_data    = new FormData();
		form_data.append('user_id',user_id);
		form_data.append('username',username);
		form_data.append('userpass',userpass);
		form_data.append('branch_id',branch_id);
		form_data.append('permission',JSON.stringify(permission));
		$.ajax({
			url:base_url+'users/update',
			type:'POST',
			processData:false,
			contentType: false,
		    data:form_data,
			success:function(response)
			{
				var res = $.parseJSON(response);
				if(res[0]==1)
				{
					notify('success','Updated');
			    }
			    else if(res[1]==3)
			    {
					notify('warning','User Already Exists');
			    }
				else
				{
					notify('error','Error try again');
				}
				$('#usersTable').DataTable().ajax.reload();
			}
		});
	});
	// Deleting
	$('#usersTable').on('click','.ifdel',function(e){
	  e.preventDefault();
	  var href = $(this).attr('href');
	  if(typeof(href) != "undefined" && href !== null)
	  {
		  swal({
		      title:"Are you sure?",
		      text: "You will not be able to recover this data!",
		      type: "warning",
		      showCancelButton: true,
		      confirmButtonClass: 'btn-danger btn-md waves-effect waves-light',
		      confirmButtonColor: "#DD6B55",
		      confirmButtonText: "Yes, delete it!",
		      cancelButtonText: "No, cancel it!",
		      closeOnConfirm: true,
		      closeOnCancel: true
		  }, function (isConfirm) {
		      if (isConfirm) 
		      {
		    	window.location=href;
		      } 
		      else 
		      {
		          return false;
		      }
		  });
	  }
	});

	$("#usersTable").on("click", ".ifdel", function (e) {
        e.preventDefault();
        user_id = $(this).attr("data-uid");
        swal(
            {
                title: "Are you sure?",
                text: "You will not be able to recover this data!",
                type: "warning",
                showCancelButton: true,
                confirmButtonClass:
                    "btn-danger btn-md waves-effect waves-light",
                confirmButtonColor: "#DD6B55",
                confirmButtonText: "Yes, delete it!",
                cancelButtonText: "No, cancel it!",
                closeOnConfirm: true,
                closeOnCancel: true,
            },
            function (isConfirm) {
                if(isConfirm){
                    $.ajax({
                        url: base_url + "users/delete",
                        type: "POST",
                        data: { user_id: user_id },
                        success: function (response) {
                            if (response == 1) {
                                notify("success", "Deleted");
                            } else {
                                notify("error", "Error deleting please try again");
                            }
                        },
                        error: function (msg) {
                            let res_errors = "";
                            $.each(msg.responseJSON.errors, function (key, value) {
                                res_errors += value + "<br>";
                            });
                            notify("warning", res_errors);
                        },
                    }); //End of Ajax Request
                    $("#usersTable").DataTable().ajax.reload();
                }

            }
        );s
    });

	
});// End Ready Function
