function refresh_dropdown() {
    var token_name = "<?php echo $this->security->get_csrf_token_name();?>";
    var token_value = $("#my_csrf").val();
    var form_data = new FormData();
    form_data.append(token_name, token_value);
    $.ajax({
        url: base_url + "expense/category/refresh_categories_items",
        type: "POST",
        processData: false,
        contentType: false,
        data: form_data,
        success: function (response) {
            var res = $.parseJSON(response);
            $("#my_csrf").val(res[0]);
            $("#stk_category").html("");
            $("#stk_category").html(res[1]);
            $("#stk_ecategory").html(res[1]);
        },
    }); //End of Ajax Request
}
function chk_avl() {
    $("#error-msg").html("");
    var aq = parseFloat($("#stk_trf_frm_qty").val());
    var b2 = parseFloat($("#stk_base_qty2").val());
    if (b2 > aq) {
        $("#error-msg").html("Quantity Exceeded");
        $("#stk_base_qty2").val(aq);
    }
}
function conversion() {
    chk_avl();
    var b1 = parseFloat($("#stk_base_qty1").val());
    var c1 = parseFloat($("#stk_converted_qty1").val());
    var b2 = parseFloat($("#stk_base_qty2").val());
    if (isNaN(b1)) {
        b1 = 0;
    }
    if (isNaN(c1)) {
        c1 = 0;
    }
    if (isNaN(b2)) {
        b2 = 0;
    }
    if (b1 > c1) {
        $("#stk_converted_qty2").val((b2 / b1) * c1);
    } else {
        $("#stk_converted_qty2").val(b2 * c1);
    }
}
$(document).ready(function () {
    $("#categoryTable").DataTable({
        ajax: {
            url: base_url + "expense/category/show",
            type: "GET", // or 'POST' if needed
        },
        language: {
            lengthMenu: "_MENU_",
        },
        pageLength: 100,
        order: [],
        responsive: true,
    });

    $("#category_name_items").on("keypress", function (e) {
        var key = e.which;
        if (key == 13) {
            e.preventDefault();
            $("#btn-add-category-items").trigger("click");
        }
    });

    $("#btn-add-category-items").on("click", function (e) {
        $("#cat-item-msg").fadeOut("slow");
        $("#cat-item-msg").removeClass();
        var category_name = $("#category_name_items").val();
        if (category_name == "") {
            notify("warning", "Provide Name for category");
            return false;
        }
        var form_data = new FormData();
        form_data.append("category_name", category_name);
        $.ajax({
            url: base_url + "expense/category/add",
            type: "POST",
            processData: false,
            contentType: false,
            data: form_data,
            success: function (response) {
                if (response == 1) {
                    notify("success", "Added");
                    $("#category_name_items").val("");
                    $("#categoryTable").DataTable().ajax.reload();
                } else {
                    notify("error", "Error Try Again");
                }
            },
            error: function (msg) {
                let res_errors = "";
                $.each(msg.responseJSON.errors, function (key, value) {
                    res_errors += value + "<br>";
                });
                notify("warning", res_errors);
            },
        }); //End of Ajax Request
    });

    $("#expense-category-edit-modal").on("show.bs.modal", function (e) {
        $("#ecat-msg").html("");
        var category_id = e.relatedTarget.id;
        $("#hcategory-id").val(category_id);
        var form_data = new FormData();
        form_data.append("category_id", category_id);
        $.ajax({
            url: base_url + "expense/category/edit",
            type: "POST",
            processData: false,
            contentType: false,
            data: form_data,
            success: function (response) {
                var res = $.parseJSON(response);
                $("#ecategory-name").val("");
                $("#ecategory-name").val(res["category_name"]);
            },
            error: function (msg) {
                let res_errors = "";
                $.each(msg.responseJSON.errors, function (key, value) {
                    res_errors += value + "<br>";
                });
                notify("warning", res_errors);
            },
        });
    });

    $("#btn-update-category-items").on("click", function (e) {
        var category_id = $("#hcategory-id").val();
        var category_name = $("#ecategory-name").val();
        var form_data = new FormData();
        form_data.append("category_id", category_id);
        form_data.append("category_name", category_name);
        if (category_name == "") {
            notify("warning", "Provide Name for category");
            return false;
        }
        $.ajax({
            url: base_url + "expense/category/update",
            type: "POST",
            processData: false,
            contentType: false,
            data: form_data,
            success: function (response) {
                if (response == 1) {
                    notify("success", "Updated");
                    $("#categoryTable").DataTable().ajax.reload();
                    // refresh_dropdown();
                } else {
                    notify("error", "Error Try Again");
                }
            },
            error: function (msg) {
                let res_errors = "";
                $.each(msg.responseJSON.errors, function (key, value) {
                    res_errors += value + "<br>";
                });
                notify("warning", res_errors);
            },
        });
    });

    // Deleting
    $("#categoryTable").on("click", ".ifdel", function (e) {
        e.preventDefault();
        var href = $(this).attr("href");
        if (typeof href != "undefined" && href !== null) {
            swal(
                {
                    title: "Are you sure?",
                    text: "You will not be able to recover this data!",
                    type: "warning",
                    showCancelButton: true,
                    confirmButtonClass:
                        "btn-danger btn-md waves-effect waves-light",
                    confirmButtonColor: "#DD6B55",
                    confirmButtonText: "Yes, delete it!",
                    cancelButtonText: "No, cancel it!",
                    closeOnConfirm: true,
                    closeOnCancel: true,
                },
                function (isConfirm) {
                    if (isConfirm) {
                        window.location = href;
                    } else {
                        return false;
                    }
                }
            );
        }
    });

	$("#categoryTable").on("click", ".ifdel", function (e) {
        e.preventDefault();
        category_id = $(this).attr("data-uid");
        swal(
            {
                title: "Are you sure?",
                text: "You will not be able to recover this data!",
                type: "warning",
                showCancelButton: true,
                confirmButtonClass:
                    "btn-danger btn-md waves-effect waves-light",
                confirmButtonColor: "#DD6B55",
                confirmButtonText: "Yes, delete it!",
                cancelButtonClass:
                    "btn-info btn-md waves-effect waves-light",
                cancelButtonColor: "#DD6B55",
                cancelButtonText: "No, cancel it!",
                closeOnConfirm: true,
                closeOnCancel: true,
            },
            function (isConfirm) {
                if(isConfirm){
                    $.ajax({
                        url: base_url + "expense/category/delete",
                        type: "POST",
                        data: { category_id: category_id },
                        success: function (response) {
                            if (response == 1) {
                                notify("success", "Deleted");
                            } else {
                                notify("error", "Error deleting please try again");
                            }
                        },
                        error: function (msg) {
                            let res_errors = "";
                            $.each(msg.responseJSON.errors, function (key, value) {
                                res_errors += value + "<br>";
                            });
                            notify("warning", res_errors);
                        },
                    }); //End of Ajax Request
                    $("#categoryTable").DataTable().ajax.reload();
                }

            }
        );s
    });
}); // End Ready Function
