<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class StockOut extends Model
{
    protected $table = 'stock_out';
    public $timestamps = false;
    protected $fillable = [
        'branch_id',
        'stk_item',
        'stk_quantity',
        'reason',
        'stk_status',
        'dated',
        'in_user',
    ];
    public function item()
    {
        return $this->belongsTo(StockItems::class, 'stk_item', 'stk_barcode');
        //                                          ^foreign key     ^owner key
    }
}
