<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class SalesDetails extends Model
{
    protected $table = 'sales_details';
    public $timestamps = false;
    protected $fillable = [
        'branch_id',
        'invoice',
        'item_barcode',
        'item_name',
        'item_pprice',
        'item_price',
        'item_qty',
        'item_total',
        'item_discount',
        'item_ftotal',
        'dated',
    ];

    public function sale()
    {
        return $this->belongsTo(Sales::class, 'invoice', 'invoice');
        //                       ^model        ^foreign key    ^owner key
    }
    public function item1()
    {
        return $this->belongsTo(Stock1::class, 'item_barcode', 'stk_barcode');
        //                             ^foreign key     ^owner key
    }
    public function item2()
    {
        return $this->belongsTo(Stock2::class, 'item_barcode', 'stk_barcode');
        //                             ^foreign key     ^owner key
    }
    public function item3()
    {
        return $this->belongsTo(Stock3::class, 'item_barcode', 'stk_barcode');
        //                             ^foreign key     ^owner key
    }
}
