<?php

namespace App\Http\Controllers;

use App\Models\Branches;
use App\Models\User;
use App\Models\Users;
use Illuminate\Http\Request;

class UserController extends Controller
{
    public function index()
	{
        $data['branches']=Branches::all();
		return view('admin.users',$data);
	}
	public function show()
	{
	   $sno=0;
	   $query = Users::orderBy('dated', 'DESC')->get();
	   if($query->count()>0)
	   {
	   	 foreach($query as $rows)
	     {
		   $sno++;
		   $dashboard=$rows->dashboard==0 ? 'No' : 'Yes';
		   $purchase=$rows->purchase==0 ? 'No' : 'Yes';
		   $stock=$rows->stock==0 ? 'No' : 'Yes';
		   $expenses=$rows->expenses==0 ? 'No' : 'Yes';
		   $services=$rows->services==0 ? 'No' : 'Yes';
		   $users=$rows->users==0 ? 'No' : 'Yes';
		   $customers=$rows->customers==0 ? 'No' : 'Yes';
		   $invoice_header=$rows->invoice_header==0 ? 'No' : 'Yes';
		   $db_backup=$rows->db_backup==0 ? 'No' : 'Yes';
		   $reports=$rows->reports==0 ? 'No' : 'Yes';
		   $stk_actions=$rows->stk_actions==0 ? 'No' : 'Yes';
		   $quotations=$rows->quotations==0 ? 'No' : 'Yes';
		   $json[]= array(
	                  	$sno,
	                 	$rows->username,
 						$rows->userpass,
                        Branches::where('branch_id', $rows->branch_id)->value('branch_name')??'Admin',
 						$dashboard,
 						$quotations,
 						$purchase,
 						$stock,
 						$expenses,
 						$services,
 						$users,
 						$customers,
 						$invoice_header,
 						$db_backup,
 						$reports,
 						$stk_actions,
 					  '<a href="#" data-toggle="modal" data-target="#user-edit-modal" class="text-warning mr-2" id="'.$rows->user_id.'"><i class="fas fa-edit"></i></button> &nbsp;'.
                      '<a href="javascript:void(0);" data-uid="'.$rows->user_id.'" class="text-danger ifdel" ><i class="fa fa-trash"></i></a>'
                     
                 );     
	     }
	     $response = array();
	     $response['success'] = true;
	     $response['aaData'] = $json;
	     echo json_encode($response);
	   }
	   else
	   {
	     $response = array();
	     $response['sEcho'] = 0;
	     $response['iTotalRecords'] = 0;
	     $response['iTotalDisplayRecords'] = 0;
	     $response['aaData'] = [];
	     echo json_encode($response);
	   }
	}
	public function add(Request $request)
	{
		$msg =null;
		$username = $request->username;
		$userpass = $request->userpass; 
		$branch_id= $request->branch_id; 
		$permission = json_decode($request->permission,true);
		$permission['username']=$username;
		$permission['userpass']=$userpass;
		$permission['branch_id']=$branch_id;
		$query = Users::where('username', $username)->first();
		if($query)
		{
			$msg=3;
		}
		else
		{
			$ins_array = $permission;
            $ins_query = Users::create($ins_array);
			if($ins_query)
			{
				$msg= 1;
			}
			else
			{
				$msg= 0;
			}
		}
		echo json_encode([$msg]);
	}	
	public function edit(Request $request)
	{
		$user_id = $request->user_id;		
        $query = Users::where('user_id', $user_id)->first();
		if($query)
		{
			$rows = $query;
			$username = $rows->username;
			$userpass = $rows->userpass;
			$branch_id= $rows->branch_id;
			$dashboard=$rows->dashboard;
			$sales=$rows->sales;
			$purchase=$rows->purchase;
			$stock=$rows->stock;
			$expenses=$rows->expenses;
			$services=$rows->services;
			$offers=$rows->offers;
			$employees=$rows->employees;
			$users=$rows->users;
			$customers=$rows->customers;
			$invoice_header=$rows->invoice_header;
			$db_backup=$rows->db_backup;
			$reports=$rows->reports;
			$stk_actions=$rows->stk_actions;
			$quotations=$rows->quotations;
			echo json_encode(['username'=>$username,
							  'userpass'=>$userpass,
							  'branch_id'=>$branch_id,
							  'sales'=>$sales,
							  'purchase'=>$purchase,
							  'stock'=>$stock,
							  'expenses'=>$expenses,
							  'services'=>$services,
							  'offers'=>$offers,
							  'employees'=>$employees,
							  'users'=>$users,
							  'customers'=>$customers,
							  'invoice_header'=>$invoice_header,
							  'db_backup'=>$db_backup,
							  'reports'=>$reports,
							  'stk_actions'=>$stk_actions,
							  'quotations'=>$quotations,
							  'dashboard'=>$dashboard]);
		}
	}
	public function update(Request $request)
	{
		$msg =null;
		$user_id = $request->user_id; 
		$username = $request->username;
		$userpass = $request->userpass; 
		$branch_id = $request->branch_id; 
		$permission = json_decode($request->permission,true);
		$permission['username']=$username;
		$permission['userpass']=$userpass;
		$permission['branch_id']=$branch_id;
		$query = Users::where('user_id', '!=', $user_id)
                          ->where('username', $username)
                          ->get();
		if($query->count()==1)
		{
			$msg =3;
		}
		else
		{
			
			$up_array =  $permission;
		    $up_query = Users::where('user_id', $user_id)->update($up_array);
			if($up_query)
			{
				$msg= 1;
			}
			else
			{
				$msg= 0;
			}
		}
		echo json_encode([$msg]);
	}
	public function delete(Request $request)
	{
		$user_id = $request->user_id;
		$msg=0;
		$delete = Users::where('user_id', $user_id)->delete();
        // Check if the delete was successful
		if($delete)
		{
			$msg=1;
		}
		echo $msg;
	}
}
