<?php

namespace App\Http\Controllers;

use App\Models\Branches;
use App\Models\ExpenseCategory;
use App\Models\Expenses;
use App\Models\ExpenseSubcategory;
use Illuminate\Http\Request;

class ExpenseController extends Controller
{
    public function index()
    {
        $categories = ExpenseCategory::orderBy('category_name', 'ASC')->get();
        $branches = Branches::orderBy('branch_name', 'ASC')->get();
        $data = ['categories' => $categories,'branches' => $branches];
        return view('admin.expenses', $data);
    }
    public function show()
    {
        $sno = 0;
        $query = Expenses::orderBy('dated', 'DESC')->get();
        if ($query->count() > 0) {
            foreach ($query as $rows) {
                $category_name = 'n/a';
                $subcategory_name = 'n/a';
                
                $q = ExpenseCategory::where('category_id', $rows->category)->first();
                if ($q) {
                    $r = $q;
                    $category_name = $r->category_name;
                }
                $branch_name = 'General';
                $q = Branches::where('branch_id', $rows->branch_id)->first();
                if ($q) {
                    $r = $q;
                    $branch_name = $r->branch_name;
                }

                $sno++;
                $json[] = array(
                    $sno,
                    $branch_name,
                    $category_name,
                    $rows->exp_title,
                    $rows->exp_date,
                    $rows->exp_amount,
                    $rows->payment_type,
                    $rows->cheque_number,
                    $rows->exp_notes,
                    $rows->dated,
                    '<a href="#" data-toggle="modal" data-target="#expense-edit-modal" id="' . $rows->exp_id . '" class="mr-3"><i class="fas fa-edit text-warning"></i></a>' .
                    '<a href="javascript:void(0);" data-uid="'.$rows->exp_id.'" class="ifdel"><i class="fa fa-trash text-danger"></i></a>',
                );
            }
            $response = array();
            $response['success'] = true;
            $response['aaData'] = $json;
            echo json_encode($response);
        } else {
            $response = array();
            $response['sEcho'] = 0;
            $response['iTotalRecords'] = 0;
            $response['iTotalDisplayRecords'] = 0;
            $response['aaData'] = [];
            echo json_encode($response);
        }
    }

    public function edit(Request $request)
    {
        $exp_id = $request->exp_id;
        $query = Expenses::where('exp_id', $exp_id)->first();
        if ($query) {
            $rows = $query;
            $branch_id = $rows->branch_id;
            $category = $rows->category;
            $exp_title = $rows->exp_title;
            $exp_date = $rows->exp_date;
            $exp_amount = $rows->exp_amount;
            $exp_notes = $rows->exp_notes;
            $options = null;
            echo json_encode([$branch_id, $category, $options, $exp_title, $exp_date, $exp_amount, $exp_notes]);
        }
    }
    public function add(Request $request)
    {
        $branch_id = $request->branch_id;
        $category = $request->category;
        $subcategory = $request->subcategory;
        $title = $request->title;
        $date = $request->date;
        $amount = $request->amount;
        $payment_type = $request->payment_type;
        $cheque_number = $request->cheque_number;
        $notes = $request->notes;

        $insarray = [
            'branch_id' => $branch_id,
            'category' => $category,
            'subcategory' => $subcategory,
            'exp_title' => $title,
            'exp_date' => $date,
            'exp_amount' => $amount,
            'payment_type' => $payment_type,
            'cheque_number' => $cheque_number,
            'exp_notes' => $notes,
            'logedin_user' => 1,
            'dated' => now()
        ];

        $insquery = Expenses::create($insarray);
        if ($insquery) {
            echo 1;
        } else {
            echo 0;
        }
    }

    public function update(Request $request)
    {
        $exp_id   = $request->exp_id;
        $branch_id = $request->branch_id;
        $category = $request->category;
        $subcategory = $request->subcategory;
        $exp_title = $request->title;
        $exp_date = $request->date;
        $exp_amount = $request->amount;
        $exp_notes = $request->notes;
        
        $query = Expenses::where('exp_id', $exp_id)
            ->where('branch_id', $branch_id)
            ->where('category', $category)
            ->where('subcategory', $subcategory)
            ->where('exp_title', $exp_title)
            ->where('exp_date', $exp_date)
            ->where('exp_amount', $exp_amount)
            ->where('exp_notes', $exp_notes)
            ->get();  
        if ($query->count() == 1) {
            echo 2;
        } else {

            $up_array = [
                'branch_id' => $branch_id,
                'category' => $category,
                'subcategory' => $subcategory,
                'exp_title' => $exp_title,
                'exp_date' => $exp_date,
                'exp_amount' => $exp_amount,
                'exp_notes' => $exp_notes,
                'logedin_user' => 1, // Assuming logedin_user is always 1 for this example
                'dated' => now() // Using Laravel's now() helper for current timestamp
            ];
            $up_query = Expenses::where('exp_id', $exp_id)->update($up_array);
            if ($up_query) {
                echo 1;
            } else {
                echo 0;
            }
        }
    }

    public function delete(Request $request)
    {
        $exp_id = $request->exp_id;
        $delete = Expenses::where('exp_id', $exp_id)->delete();
        // Check if the delete was successful
        $msg=0;
        if ($delete) {
            $msg=1;
        } 
        echo $msg;
    }
}
